# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.issues_create_request_labels_inner import IssuesCreateRequestLabelsInner
from devopso.clients.github.models.issues_update_request_milestone import IssuesUpdateRequestMilestone
from devopso.clients.github.models.issues_update_request_title import IssuesUpdateRequestTitle
from typing import Optional, Set
from typing_extensions import Self

class IssuesUpdateRequest(BaseModel):
    """
    IssuesUpdateRequest
    """ # noqa: E501
    title: Optional[IssuesUpdateRequestTitle] = None
    body: Optional[StrictStr] = Field(default=None, description="The contents of the issue.")
    assignee: Optional[StrictStr] = Field(default=None, description="Username to assign to this issue. **This field is closing down.**")
    state: Optional[StrictStr] = Field(default=None, description="The open or closed state of the issue.")
    state_reason: Optional[StrictStr] = Field(default=None, description="The reason for the state change. Ignored unless `state` is changed.")
    milestone: Optional[IssuesUpdateRequestMilestone] = None
    labels: Optional[List[IssuesCreateRequestLabelsInner]] = Field(default=None, description="Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.")
    assignees: Optional[List[StrictStr]] = Field(default=None, description="Usernames to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this issue. Send an empty array (`[]`) to clear all assignees from the issue. Only users with push access can set assignees for new issues. Without push access to the repository, assignee changes are silently dropped.")
    type: Optional[StrictStr] = Field(default=None, description="The name of the issue type to associate with this issue or use `null` to remove the current issue type. Only users with push access can set the type for issues. Without push access to the repository, type changes are silently dropped.")
    __properties: ClassVar[List[str]] = ["title", "body", "assignee", "state", "state_reason", "milestone", "labels", "assignees", "type"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'closed']):
            raise ValueError("must be one of enum values ('open', 'closed')")
        return value

    @field_validator('state_reason')
    def state_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['completed', 'not_planned', 'duplicate', 'reopened']):
            raise ValueError("must be one of enum values ('completed', 'not_planned', 'duplicate', 'reopened')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuesUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of title
        if self.title:
            _dict['title'] = self.title.to_dict()
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if state_reason (nullable) is None
        # and model_fields_set contains the field
        if self.state_reason is None and "state_reason" in self.model_fields_set:
            _dict['state_reason'] = None

        # set to None if milestone (nullable) is None
        # and model_fields_set contains the field
        if self.milestone is None and "milestone" in self.model_fields_set:
            _dict['milestone'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuesUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": IssuesUpdateRequestTitle.from_dict(obj["title"]) if obj.get("title") is not None else None,
            "body": obj.get("body"),
            "assignee": obj.get("assignee"),
            "state": obj.get("state"),
            "state_reason": obj.get("state_reason"),
            "milestone": IssuesUpdateRequestMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "labels": [IssuesCreateRequestLabelsInner.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "assignees": obj.get("assignees"),
            "type": obj.get("type")
        })
        return _obj


