# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MarketplaceListingPlan(BaseModel):
    """
    Marketplace Listing Plan
    """ # noqa: E501
    url: StrictStr
    accounts_url: StrictStr
    id: StrictInt
    number: StrictInt
    name: StrictStr
    description: StrictStr
    monthly_price_in_cents: StrictInt
    yearly_price_in_cents: StrictInt
    price_model: StrictStr
    has_free_trial: StrictBool
    unit_name: Optional[StrictStr]
    state: StrictStr
    bullets: List[StrictStr]
    __properties: ClassVar[List[str]] = ["url", "accounts_url", "id", "number", "name", "description", "monthly_price_in_cents", "yearly_price_in_cents", "price_model", "has_free_trial", "unit_name", "state", "bullets"]

    @field_validator('price_model')
    def price_model_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['FREE', 'FLAT_RATE', 'PER_UNIT']):
            raise ValueError("must be one of enum values ('FREE', 'FLAT_RATE', 'PER_UNIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketplaceListingPlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if unit_name (nullable) is None
        # and model_fields_set contains the field
        if self.unit_name is None and "unit_name" in self.model_fields_set:
            _dict['unit_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketplaceListingPlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "accounts_url": obj.get("accounts_url"),
            "id": obj.get("id"),
            "number": obj.get("number"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "monthly_price_in_cents": obj.get("monthly_price_in_cents"),
            "yearly_price_in_cents": obj.get("yearly_price_in_cents"),
            "price_model": obj.get("price_model"),
            "has_free_trial": obj.get("has_free_trial"),
            "unit_name": obj.get("unit_name"),
            "state": obj.get("state"),
            "bullets": obj.get("bullets")
        })
        return _obj


