# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhooks_marketplace_purchase_account import WebhooksMarketplacePurchaseAccount
from devopso.clients.github.models.webhooks_previous_marketplace_purchase_plan import WebhooksPreviousMarketplacePurchasePlan
from typing import Optional, Set
from typing_extensions import Self

class MarketplacePurchase2(BaseModel):
    """
    MarketplacePurchase2
    """ # noqa: E501
    account: WebhooksMarketplacePurchaseAccount
    billing_cycle: StrictStr
    free_trial_ends_on: Optional[Any]
    next_billing_date: Optional[StrictStr]
    on_free_trial: StrictBool
    plan: WebhooksPreviousMarketplacePurchasePlan
    unit_count: StrictInt
    __properties: ClassVar[List[str]] = ["account", "billing_cycle", "free_trial_ends_on", "next_billing_date", "on_free_trial", "plan", "unit_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketplacePurchase2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # set to None if free_trial_ends_on (nullable) is None
        # and model_fields_set contains the field
        if self.free_trial_ends_on is None and "free_trial_ends_on" in self.model_fields_set:
            _dict['free_trial_ends_on'] = None

        # set to None if next_billing_date (nullable) is None
        # and model_fields_set contains the field
        if self.next_billing_date is None and "next_billing_date" in self.model_fields_set:
            _dict['next_billing_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketplacePurchase2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account": WebhooksMarketplacePurchaseAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "billing_cycle": obj.get("billing_cycle"),
            "free_trial_ends_on": obj.get("free_trial_ends_on"),
            "next_billing_date": obj.get("next_billing_date"),
            "on_free_trial": obj.get("on_free_trial"),
            "plan": WebhooksPreviousMarketplacePurchasePlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "unit_count": obj.get("unit_count")
        })
        return _obj


