# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.simple_commit import SimpleCommit
from typing import Optional, Set
from typing_extensions import Self

class MergeGroup(BaseModel):
    """
    A group of pull requests that the merge queue has grouped together to be merged.
    """ # noqa: E501
    head_sha: StrictStr = Field(description="The SHA of the merge group.")
    head_ref: StrictStr = Field(description="The full ref of the merge group.")
    base_sha: StrictStr = Field(description="The SHA of the merge group's parent commit.")
    base_ref: StrictStr = Field(description="The full ref of the branch the merge group will be merged into.")
    head_commit: SimpleCommit
    __properties: ClassVar[List[str]] = ["head_sha", "head_ref", "base_sha", "base_ref", "head_commit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MergeGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of head_commit
        if self.head_commit:
            _dict['head_commit'] = self.head_commit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MergeGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "head_sha": obj.get("head_sha"),
            "head_ref": obj.get("head_ref"),
            "base_sha": obj.get("base_sha"),
            "base_ref": obj.get("base_ref"),
            "head_commit": SimpleCommit.from_dict(obj["head_commit"]) if obj.get("head_commit") is not None else None
        })
        return _obj


