# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MigrationsStartForAuthenticatedUserRequest(BaseModel):
    """
    MigrationsStartForAuthenticatedUserRequest
    """ # noqa: E501
    lock_repositories: Optional[StrictBool] = Field(default=None, description="Lock the repositories being migrated at the start of the migration")
    exclude_metadata: Optional[StrictBool] = Field(default=None, description="Indicates whether metadata should be excluded and only git source should be included for the migration.")
    exclude_git_data: Optional[StrictBool] = Field(default=None, description="Indicates whether the repository git data should be excluded from the migration.")
    exclude_attachments: Optional[StrictBool] = Field(default=None, description="Do not include attachments in the migration")
    exclude_releases: Optional[StrictBool] = Field(default=None, description="Do not include releases in the migration")
    exclude_owner_projects: Optional[StrictBool] = Field(default=None, description="Indicates whether projects owned by the organization or users should be excluded.")
    org_metadata_only: Optional[StrictBool] = Field(default=False, description="Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).")
    exclude: Optional[List[StrictStr]] = Field(default=None, description="Exclude attributes from the API response to improve performance")
    repositories: List[StrictStr]
    __properties: ClassVar[List[str]] = ["lock_repositories", "exclude_metadata", "exclude_git_data", "exclude_attachments", "exclude_releases", "exclude_owner_projects", "org_metadata_only", "exclude", "repositories"]

    @field_validator('exclude')
    def exclude_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['repositories']):
                raise ValueError("each list item must be one of ('repositories')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MigrationsStartForAuthenticatedUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MigrationsStartForAuthenticatedUserRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lock_repositories": obj.get("lock_repositories"),
            "exclude_metadata": obj.get("exclude_metadata"),
            "exclude_git_data": obj.get("exclude_git_data"),
            "exclude_attachments": obj.get("exclude_attachments"),
            "exclude_releases": obj.get("exclude_releases"),
            "exclude_owner_projects": obj.get("exclude_owner_projects"),
            "org_metadata_only": obj.get("org_metadata_only") if obj.get("org_metadata_only") is not None else False,
            "exclude": obj.get("exclude"),
            "repositories": obj.get("repositories")
        })
        return _obj


