# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MigrationsUpdateImportRequest(BaseModel):
    """
    MigrationsUpdateImportRequest
    """ # noqa: E501
    vcs_username: Optional[StrictStr] = Field(default=None, description="The username to provide to the originating repository.")
    vcs_password: Optional[StrictStr] = Field(default=None, description="The password to provide to the originating repository.")
    vcs: Optional[StrictStr] = Field(default=None, description="The type of version control system you are migrating from.")
    tfvc_project: Optional[StrictStr] = Field(default=None, description="For a tfvc import, the name of the project that is being imported.")
    __properties: ClassVar[List[str]] = ["vcs_username", "vcs_password", "vcs", "tfvc_project"]

    @field_validator('vcs')
    def vcs_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['subversion', 'tfvc', 'git', 'mercurial']):
            raise ValueError("must be one of enum values ('subversion', 'tfvc', 'git', 'mercurial')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MigrationsUpdateImportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MigrationsUpdateImportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "vcs_username": obj.get("vcs_username"),
            "vcs_password": obj.get("vcs_password"),
            "vcs": obj.get("vcs"),
            "tfvc_project": obj.get("tfvc_project")
        })
        return _obj


