# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.code_of_conduct import CodeOfConduct
from devopso.clients.github.models.minimal_repository_license import MinimalRepositoryLicense
from devopso.clients.github.models.minimal_repository_permissions import MinimalRepositoryPermissions
from devopso.clients.github.models.security_and_analysis import SecurityAndAnalysis
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class MinimalRepository(BaseModel):
    """
    Minimal Repository
    """ # noqa: E501
    id: StrictInt
    node_id: StrictStr
    name: StrictStr
    full_name: StrictStr
    owner: SimpleUser
    private: StrictBool
    html_url: StrictStr
    description: Optional[StrictStr]
    fork: StrictBool
    url: StrictStr
    archive_url: StrictStr
    assignees_url: StrictStr
    blobs_url: StrictStr
    branches_url: StrictStr
    collaborators_url: StrictStr
    comments_url: StrictStr
    commits_url: StrictStr
    compare_url: StrictStr
    contents_url: StrictStr
    contributors_url: StrictStr
    deployments_url: StrictStr
    downloads_url: StrictStr
    events_url: StrictStr
    forks_url: StrictStr
    git_commits_url: StrictStr
    git_refs_url: StrictStr
    git_tags_url: StrictStr
    git_url: Optional[StrictStr] = None
    issue_comment_url: StrictStr
    issue_events_url: StrictStr
    issues_url: StrictStr
    keys_url: StrictStr
    labels_url: StrictStr
    languages_url: StrictStr
    merges_url: StrictStr
    milestones_url: StrictStr
    notifications_url: StrictStr
    pulls_url: StrictStr
    releases_url: StrictStr
    ssh_url: Optional[StrictStr] = None
    stargazers_url: StrictStr
    statuses_url: StrictStr
    subscribers_url: StrictStr
    subscription_url: StrictStr
    tags_url: StrictStr
    teams_url: StrictStr
    trees_url: StrictStr
    clone_url: Optional[StrictStr] = None
    mirror_url: Optional[StrictStr] = None
    hooks_url: StrictStr
    svn_url: Optional[StrictStr] = None
    homepage: Optional[StrictStr] = None
    language: Optional[StrictStr] = None
    forks_count: Optional[StrictInt] = None
    stargazers_count: Optional[StrictInt] = None
    watchers_count: Optional[StrictInt] = None
    size: Optional[StrictInt] = Field(default=None, description="The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.")
    default_branch: Optional[StrictStr] = None
    open_issues_count: Optional[StrictInt] = None
    is_template: Optional[StrictBool] = None
    topics: Optional[List[StrictStr]] = None
    has_issues: Optional[StrictBool] = None
    has_projects: Optional[StrictBool] = None
    has_wiki: Optional[StrictBool] = None
    has_pages: Optional[StrictBool] = None
    has_downloads: Optional[StrictBool] = None
    has_discussions: Optional[StrictBool] = None
    archived: Optional[StrictBool] = None
    disabled: Optional[StrictBool] = None
    visibility: Optional[StrictStr] = None
    pushed_at: Optional[datetime] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    permissions: Optional[MinimalRepositoryPermissions] = None
    role_name: Optional[StrictStr] = None
    temp_clone_token: Optional[StrictStr] = None
    delete_branch_on_merge: Optional[StrictBool] = None
    subscribers_count: Optional[StrictInt] = None
    network_count: Optional[StrictInt] = None
    code_of_conduct: Optional[CodeOfConduct] = None
    license: Optional[MinimalRepositoryLicense] = None
    forks: Optional[StrictInt] = None
    open_issues: Optional[StrictInt] = None
    watchers: Optional[StrictInt] = None
    allow_forking: Optional[StrictBool] = None
    web_commit_signoff_required: Optional[StrictBool] = None
    security_and_analysis: Optional[SecurityAndAnalysis] = None
    custom_properties: Optional[Dict[str, Any]] = Field(default=None, description="The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.")
    __properties: ClassVar[List[str]] = ["id", "node_id", "name", "full_name", "owner", "private", "html_url", "description", "fork", "url", "archive_url", "assignees_url", "blobs_url", "branches_url", "collaborators_url", "comments_url", "commits_url", "compare_url", "contents_url", "contributors_url", "deployments_url", "downloads_url", "events_url", "forks_url", "git_commits_url", "git_refs_url", "git_tags_url", "git_url", "issue_comment_url", "issue_events_url", "issues_url", "keys_url", "labels_url", "languages_url", "merges_url", "milestones_url", "notifications_url", "pulls_url", "releases_url", "ssh_url", "stargazers_url", "statuses_url", "subscribers_url", "subscription_url", "tags_url", "teams_url", "trees_url", "clone_url", "mirror_url", "hooks_url", "svn_url", "homepage", "language", "forks_count", "stargazers_count", "watchers_count", "size", "default_branch", "open_issues_count", "is_template", "topics", "has_issues", "has_projects", "has_wiki", "has_pages", "has_downloads", "has_discussions", "archived", "disabled", "visibility", "pushed_at", "created_at", "updated_at", "permissions", "role_name", "temp_clone_token", "delete_branch_on_merge", "subscribers_count", "network_count", "code_of_conduct", "license", "forks", "open_issues", "watchers", "allow_forking", "web_commit_signoff_required", "security_and_analysis", "custom_properties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MinimalRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of code_of_conduct
        if self.code_of_conduct:
            _dict['code_of_conduct'] = self.code_of_conduct.to_dict()
        # override the default output from pydantic by calling `to_dict()` of license
        if self.license:
            _dict['license'] = self.license.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_and_analysis
        if self.security_and_analysis:
            _dict['security_and_analysis'] = self.security_and_analysis.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if mirror_url (nullable) is None
        # and model_fields_set contains the field
        if self.mirror_url is None and "mirror_url" in self.model_fields_set:
            _dict['mirror_url'] = None

        # set to None if homepage (nullable) is None
        # and model_fields_set contains the field
        if self.homepage is None and "homepage" in self.model_fields_set:
            _dict['homepage'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if pushed_at (nullable) is None
        # and model_fields_set contains the field
        if self.pushed_at is None and "pushed_at" in self.model_fields_set:
            _dict['pushed_at'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if license (nullable) is None
        # and model_fields_set contains the field
        if self.license is None and "license" in self.model_fields_set:
            _dict['license'] = None

        # set to None if security_and_analysis (nullable) is None
        # and model_fields_set contains the field
        if self.security_and_analysis is None and "security_and_analysis" in self.model_fields_set:
            _dict['security_and_analysis'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MinimalRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "name": obj.get("name"),
            "full_name": obj.get("full_name"),
            "owner": SimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "private": obj.get("private"),
            "html_url": obj.get("html_url"),
            "description": obj.get("description"),
            "fork": obj.get("fork"),
            "url": obj.get("url"),
            "archive_url": obj.get("archive_url"),
            "assignees_url": obj.get("assignees_url"),
            "blobs_url": obj.get("blobs_url"),
            "branches_url": obj.get("branches_url"),
            "collaborators_url": obj.get("collaborators_url"),
            "comments_url": obj.get("comments_url"),
            "commits_url": obj.get("commits_url"),
            "compare_url": obj.get("compare_url"),
            "contents_url": obj.get("contents_url"),
            "contributors_url": obj.get("contributors_url"),
            "deployments_url": obj.get("deployments_url"),
            "downloads_url": obj.get("downloads_url"),
            "events_url": obj.get("events_url"),
            "forks_url": obj.get("forks_url"),
            "git_commits_url": obj.get("git_commits_url"),
            "git_refs_url": obj.get("git_refs_url"),
            "git_tags_url": obj.get("git_tags_url"),
            "git_url": obj.get("git_url"),
            "issue_comment_url": obj.get("issue_comment_url"),
            "issue_events_url": obj.get("issue_events_url"),
            "issues_url": obj.get("issues_url"),
            "keys_url": obj.get("keys_url"),
            "labels_url": obj.get("labels_url"),
            "languages_url": obj.get("languages_url"),
            "merges_url": obj.get("merges_url"),
            "milestones_url": obj.get("milestones_url"),
            "notifications_url": obj.get("notifications_url"),
            "pulls_url": obj.get("pulls_url"),
            "releases_url": obj.get("releases_url"),
            "ssh_url": obj.get("ssh_url"),
            "stargazers_url": obj.get("stargazers_url"),
            "statuses_url": obj.get("statuses_url"),
            "subscribers_url": obj.get("subscribers_url"),
            "subscription_url": obj.get("subscription_url"),
            "tags_url": obj.get("tags_url"),
            "teams_url": obj.get("teams_url"),
            "trees_url": obj.get("trees_url"),
            "clone_url": obj.get("clone_url"),
            "mirror_url": obj.get("mirror_url"),
            "hooks_url": obj.get("hooks_url"),
            "svn_url": obj.get("svn_url"),
            "homepage": obj.get("homepage"),
            "language": obj.get("language"),
            "forks_count": obj.get("forks_count"),
            "stargazers_count": obj.get("stargazers_count"),
            "watchers_count": obj.get("watchers_count"),
            "size": obj.get("size"),
            "default_branch": obj.get("default_branch"),
            "open_issues_count": obj.get("open_issues_count"),
            "is_template": obj.get("is_template"),
            "topics": obj.get("topics"),
            "has_issues": obj.get("has_issues"),
            "has_projects": obj.get("has_projects"),
            "has_wiki": obj.get("has_wiki"),
            "has_pages": obj.get("has_pages"),
            "has_downloads": obj.get("has_downloads"),
            "has_discussions": obj.get("has_discussions"),
            "archived": obj.get("archived"),
            "disabled": obj.get("disabled"),
            "visibility": obj.get("visibility"),
            "pushed_at": obj.get("pushed_at"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "permissions": MinimalRepositoryPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "role_name": obj.get("role_name"),
            "temp_clone_token": obj.get("temp_clone_token"),
            "delete_branch_on_merge": obj.get("delete_branch_on_merge"),
            "subscribers_count": obj.get("subscribers_count"),
            "network_count": obj.get("network_count"),
            "code_of_conduct": CodeOfConduct.from_dict(obj["code_of_conduct"]) if obj.get("code_of_conduct") is not None else None,
            "license": MinimalRepositoryLicense.from_dict(obj["license"]) if obj.get("license") is not None else None,
            "forks": obj.get("forks"),
            "open_issues": obj.get("open_issues"),
            "watchers": obj.get("watchers"),
            "allow_forking": obj.get("allow_forking"),
            "web_commit_signoff_required": obj.get("web_commit_signoff_required"),
            "security_and_analysis": SecurityAndAnalysis.from_dict(obj["security_and_analysis"]) if obj.get("security_and_analysis") is not None else None,
            "custom_properties": obj.get("custom_properties")
        })
        return _obj


