# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.app_permissions import AppPermissions
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class NullableScopedInstallation(BaseModel):
    """
    NullableScopedInstallation
    """ # noqa: E501
    permissions: AppPermissions
    repository_selection: StrictStr = Field(description="Describe whether all repositories have been selected or there's a selection involved")
    single_file_name: Optional[StrictStr]
    has_multiple_single_files: Optional[StrictBool] = None
    single_file_paths: Optional[List[StrictStr]] = None
    repositories_url: StrictStr
    account: SimpleUser
    __properties: ClassVar[List[str]] = ["permissions", "repository_selection", "single_file_name", "has_multiple_single_files", "single_file_paths", "repositories_url", "account"]

    @field_validator('repository_selection')
    def repository_selection_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['all', 'selected']):
            raise ValueError("must be one of enum values ('all', 'selected')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NullableScopedInstallation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # set to None if single_file_name (nullable) is None
        # and model_fields_set contains the field
        if self.single_file_name is None and "single_file_name" in self.model_fields_set:
            _dict['single_file_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NullableScopedInstallation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "permissions": AppPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "repository_selection": obj.get("repository_selection"),
            "single_file_name": obj.get("single_file_name"),
            "has_multiple_single_files": obj.get("has_multiple_single_files"),
            "single_file_paths": obj.get("single_file_paths"),
            "repositories_url": obj.get("repositories_url"),
            "account": SimpleUser.from_dict(obj["account"]) if obj.get("account") is not None else None
        })
        return _obj


