# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from devopso.clients.github.models.secret_scanning_location_commit import SecretScanningLocationCommit
from devopso.clients.github.models.secret_scanning_location_discussion_body import SecretScanningLocationDiscussionBody
from devopso.clients.github.models.secret_scanning_location_discussion_comment import SecretScanningLocationDiscussionComment
from devopso.clients.github.models.secret_scanning_location_discussion_title import SecretScanningLocationDiscussionTitle
from devopso.clients.github.models.secret_scanning_location_issue_body import SecretScanningLocationIssueBody
from devopso.clients.github.models.secret_scanning_location_issue_comment import SecretScanningLocationIssueComment
from devopso.clients.github.models.secret_scanning_location_issue_title import SecretScanningLocationIssueTitle
from devopso.clients.github.models.secret_scanning_location_pull_request_body import SecretScanningLocationPullRequestBody
from devopso.clients.github.models.secret_scanning_location_pull_request_comment import SecretScanningLocationPullRequestComment
from devopso.clients.github.models.secret_scanning_location_pull_request_review import SecretScanningLocationPullRequestReview
from devopso.clients.github.models.secret_scanning_location_pull_request_review_comment import SecretScanningLocationPullRequestReviewComment
from devopso.clients.github.models.secret_scanning_location_pull_request_title import SecretScanningLocationPullRequestTitle
from devopso.clients.github.models.secret_scanning_location_wiki_commit import SecretScanningLocationWikiCommit
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

NULLABLESECRETSCANNINGFIRSTDETECTEDLOCATION_ONE_OF_SCHEMAS = ["SecretScanningLocationCommit", "SecretScanningLocationDiscussionBody", "SecretScanningLocationDiscussionComment", "SecretScanningLocationDiscussionTitle", "SecretScanningLocationIssueBody", "SecretScanningLocationIssueComment", "SecretScanningLocationIssueTitle", "SecretScanningLocationPullRequestBody", "SecretScanningLocationPullRequestComment", "SecretScanningLocationPullRequestReview", "SecretScanningLocationPullRequestReviewComment", "SecretScanningLocationPullRequestTitle", "SecretScanningLocationWikiCommit"]

class NullableSecretScanningFirstDetectedLocation(BaseModel):
    """
    Details on the location where the token was initially detected. This can be a commit, wiki commit, issue, discussion, pull request. 
    """
    # data type: SecretScanningLocationCommit
    oneof_schema_1_validator: Optional[SecretScanningLocationCommit] = None
    # data type: SecretScanningLocationWikiCommit
    oneof_schema_2_validator: Optional[SecretScanningLocationWikiCommit] = None
    # data type: SecretScanningLocationIssueTitle
    oneof_schema_3_validator: Optional[SecretScanningLocationIssueTitle] = None
    # data type: SecretScanningLocationIssueBody
    oneof_schema_4_validator: Optional[SecretScanningLocationIssueBody] = None
    # data type: SecretScanningLocationIssueComment
    oneof_schema_5_validator: Optional[SecretScanningLocationIssueComment] = None
    # data type: SecretScanningLocationDiscussionTitle
    oneof_schema_6_validator: Optional[SecretScanningLocationDiscussionTitle] = None
    # data type: SecretScanningLocationDiscussionBody
    oneof_schema_7_validator: Optional[SecretScanningLocationDiscussionBody] = None
    # data type: SecretScanningLocationDiscussionComment
    oneof_schema_8_validator: Optional[SecretScanningLocationDiscussionComment] = None
    # data type: SecretScanningLocationPullRequestTitle
    oneof_schema_9_validator: Optional[SecretScanningLocationPullRequestTitle] = None
    # data type: SecretScanningLocationPullRequestBody
    oneof_schema_10_validator: Optional[SecretScanningLocationPullRequestBody] = None
    # data type: SecretScanningLocationPullRequestComment
    oneof_schema_11_validator: Optional[SecretScanningLocationPullRequestComment] = None
    # data type: SecretScanningLocationPullRequestReview
    oneof_schema_12_validator: Optional[SecretScanningLocationPullRequestReview] = None
    # data type: SecretScanningLocationPullRequestReviewComment
    oneof_schema_13_validator: Optional[SecretScanningLocationPullRequestReviewComment] = None
    actual_instance: Optional[Union[SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit]] = None
    one_of_schemas: Set[str] = { "SecretScanningLocationCommit", "SecretScanningLocationDiscussionBody", "SecretScanningLocationDiscussionComment", "SecretScanningLocationDiscussionTitle", "SecretScanningLocationIssueBody", "SecretScanningLocationIssueComment", "SecretScanningLocationIssueTitle", "SecretScanningLocationPullRequestBody", "SecretScanningLocationPullRequestComment", "SecretScanningLocationPullRequestReview", "SecretScanningLocationPullRequestReviewComment", "SecretScanningLocationPullRequestTitle", "SecretScanningLocationWikiCommit" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        if v is None:
            return v

        instance = NullableSecretScanningFirstDetectedLocation.model_construct()
        error_messages = []
        match = 0
        # validate data type: SecretScanningLocationCommit
        if not isinstance(v, SecretScanningLocationCommit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationCommit`")
        else:
            match += 1
        # validate data type: SecretScanningLocationWikiCommit
        if not isinstance(v, SecretScanningLocationWikiCommit):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationWikiCommit`")
        else:
            match += 1
        # validate data type: SecretScanningLocationIssueTitle
        if not isinstance(v, SecretScanningLocationIssueTitle):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationIssueTitle`")
        else:
            match += 1
        # validate data type: SecretScanningLocationIssueBody
        if not isinstance(v, SecretScanningLocationIssueBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationIssueBody`")
        else:
            match += 1
        # validate data type: SecretScanningLocationIssueComment
        if not isinstance(v, SecretScanningLocationIssueComment):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationIssueComment`")
        else:
            match += 1
        # validate data type: SecretScanningLocationDiscussionTitle
        if not isinstance(v, SecretScanningLocationDiscussionTitle):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationDiscussionTitle`")
        else:
            match += 1
        # validate data type: SecretScanningLocationDiscussionBody
        if not isinstance(v, SecretScanningLocationDiscussionBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationDiscussionBody`")
        else:
            match += 1
        # validate data type: SecretScanningLocationDiscussionComment
        if not isinstance(v, SecretScanningLocationDiscussionComment):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationDiscussionComment`")
        else:
            match += 1
        # validate data type: SecretScanningLocationPullRequestTitle
        if not isinstance(v, SecretScanningLocationPullRequestTitle):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationPullRequestTitle`")
        else:
            match += 1
        # validate data type: SecretScanningLocationPullRequestBody
        if not isinstance(v, SecretScanningLocationPullRequestBody):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationPullRequestBody`")
        else:
            match += 1
        # validate data type: SecretScanningLocationPullRequestComment
        if not isinstance(v, SecretScanningLocationPullRequestComment):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationPullRequestComment`")
        else:
            match += 1
        # validate data type: SecretScanningLocationPullRequestReview
        if not isinstance(v, SecretScanningLocationPullRequestReview):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationPullRequestReview`")
        else:
            match += 1
        # validate data type: SecretScanningLocationPullRequestReviewComment
        if not isinstance(v, SecretScanningLocationPullRequestReviewComment):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecretScanningLocationPullRequestReviewComment`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in NullableSecretScanningFirstDetectedLocation with oneOf schemas: SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in NullableSecretScanningFirstDetectedLocation with oneOf schemas: SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: Optional[str]) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        match = 0

        # deserialize data into SecretScanningLocationCommit
        try:
            instance.actual_instance = SecretScanningLocationCommit.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationWikiCommit
        try:
            instance.actual_instance = SecretScanningLocationWikiCommit.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationIssueTitle
        try:
            instance.actual_instance = SecretScanningLocationIssueTitle.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationIssueBody
        try:
            instance.actual_instance = SecretScanningLocationIssueBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationIssueComment
        try:
            instance.actual_instance = SecretScanningLocationIssueComment.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationDiscussionTitle
        try:
            instance.actual_instance = SecretScanningLocationDiscussionTitle.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationDiscussionBody
        try:
            instance.actual_instance = SecretScanningLocationDiscussionBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationDiscussionComment
        try:
            instance.actual_instance = SecretScanningLocationDiscussionComment.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationPullRequestTitle
        try:
            instance.actual_instance = SecretScanningLocationPullRequestTitle.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationPullRequestBody
        try:
            instance.actual_instance = SecretScanningLocationPullRequestBody.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationPullRequestComment
        try:
            instance.actual_instance = SecretScanningLocationPullRequestComment.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationPullRequestReview
        try:
            instance.actual_instance = SecretScanningLocationPullRequestReview.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SecretScanningLocationPullRequestReviewComment
        try:
            instance.actual_instance = SecretScanningLocationPullRequestReviewComment.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into NullableSecretScanningFirstDetectedLocation with oneOf schemas: SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into NullableSecretScanningFirstDetectedLocation with oneOf schemas: SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], SecretScanningLocationCommit, SecretScanningLocationDiscussionBody, SecretScanningLocationDiscussionComment, SecretScanningLocationDiscussionTitle, SecretScanningLocationIssueBody, SecretScanningLocationIssueComment, SecretScanningLocationIssueTitle, SecretScanningLocationPullRequestBody, SecretScanningLocationPullRequestComment, SecretScanningLocationPullRequestReview, SecretScanningLocationPullRequestReviewComment, SecretScanningLocationPullRequestTitle, SecretScanningLocationWikiCommit]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


