# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class NullableSimpleRepository(BaseModel):
    """
    A GitHub repository.
    """ # noqa: E501
    id: StrictInt = Field(description="A unique identifier of the repository.")
    node_id: StrictStr = Field(description="The GraphQL identifier of the repository.")
    name: StrictStr = Field(description="The name of the repository.")
    full_name: StrictStr = Field(description="The full, globally unique, name of the repository.")
    owner: SimpleUser
    private: StrictBool = Field(description="Whether the repository is private.")
    html_url: StrictStr = Field(description="The URL to view the repository on GitHub.com.")
    description: Optional[StrictStr] = Field(description="The repository description.")
    fork: StrictBool = Field(description="Whether the repository is a fork.")
    url: StrictStr = Field(description="The URL to get more information about the repository from the GitHub API.")
    archive_url: StrictStr = Field(description="A template for the API URL to download the repository as an archive.")
    assignees_url: StrictStr = Field(description="A template for the API URL to list the available assignees for issues in the repository.")
    blobs_url: StrictStr = Field(description="A template for the API URL to create or retrieve a raw Git blob in the repository.")
    branches_url: StrictStr = Field(description="A template for the API URL to get information about branches in the repository.")
    collaborators_url: StrictStr = Field(description="A template for the API URL to get information about collaborators of the repository.")
    comments_url: StrictStr = Field(description="A template for the API URL to get information about comments on the repository.")
    commits_url: StrictStr = Field(description="A template for the API URL to get information about commits on the repository.")
    compare_url: StrictStr = Field(description="A template for the API URL to compare two commits or refs.")
    contents_url: StrictStr = Field(description="A template for the API URL to get the contents of the repository.")
    contributors_url: StrictStr = Field(description="A template for the API URL to list the contributors to the repository.")
    deployments_url: StrictStr = Field(description="The API URL to list the deployments of the repository.")
    downloads_url: StrictStr = Field(description="The API URL to list the downloads on the repository.")
    events_url: StrictStr = Field(description="The API URL to list the events of the repository.")
    forks_url: StrictStr = Field(description="The API URL to list the forks of the repository.")
    git_commits_url: StrictStr = Field(description="A template for the API URL to get information about Git commits of the repository.")
    git_refs_url: StrictStr = Field(description="A template for the API URL to get information about Git refs of the repository.")
    git_tags_url: StrictStr = Field(description="A template for the API URL to get information about Git tags of the repository.")
    issue_comment_url: StrictStr = Field(description="A template for the API URL to get information about issue comments on the repository.")
    issue_events_url: StrictStr = Field(description="A template for the API URL to get information about issue events on the repository.")
    issues_url: StrictStr = Field(description="A template for the API URL to get information about issues on the repository.")
    keys_url: StrictStr = Field(description="A template for the API URL to get information about deploy keys on the repository.")
    labels_url: StrictStr = Field(description="A template for the API URL to get information about labels of the repository.")
    languages_url: StrictStr = Field(description="The API URL to get information about the languages of the repository.")
    merges_url: StrictStr = Field(description="The API URL to merge branches in the repository.")
    milestones_url: StrictStr = Field(description="A template for the API URL to get information about milestones of the repository.")
    notifications_url: StrictStr = Field(description="A template for the API URL to get information about notifications on the repository.")
    pulls_url: StrictStr = Field(description="A template for the API URL to get information about pull requests on the repository.")
    releases_url: StrictStr = Field(description="A template for the API URL to get information about releases on the repository.")
    stargazers_url: StrictStr = Field(description="The API URL to list the stargazers on the repository.")
    statuses_url: StrictStr = Field(description="A template for the API URL to get information about statuses of a commit.")
    subscribers_url: StrictStr = Field(description="The API URL to list the subscribers on the repository.")
    subscription_url: StrictStr = Field(description="The API URL to subscribe to notifications for this repository.")
    tags_url: StrictStr = Field(description="The API URL to get information about tags on the repository.")
    teams_url: StrictStr = Field(description="The API URL to list the teams on the repository.")
    trees_url: StrictStr = Field(description="A template for the API URL to create or retrieve a raw Git tree of the repository.")
    hooks_url: StrictStr = Field(description="The API URL to list the hooks on the repository.")
    __properties: ClassVar[List[str]] = ["id", "node_id", "name", "full_name", "owner", "private", "html_url", "description", "fork", "url", "archive_url", "assignees_url", "blobs_url", "branches_url", "collaborators_url", "comments_url", "commits_url", "compare_url", "contents_url", "contributors_url", "deployments_url", "downloads_url", "events_url", "forks_url", "git_commits_url", "git_refs_url", "git_tags_url", "issue_comment_url", "issue_events_url", "issues_url", "keys_url", "labels_url", "languages_url", "merges_url", "milestones_url", "notifications_url", "pulls_url", "releases_url", "stargazers_url", "statuses_url", "subscribers_url", "subscription_url", "tags_url", "teams_url", "trees_url", "hooks_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NullableSimpleRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NullableSimpleRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "name": obj.get("name"),
            "full_name": obj.get("full_name"),
            "owner": SimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "private": obj.get("private"),
            "html_url": obj.get("html_url"),
            "description": obj.get("description"),
            "fork": obj.get("fork"),
            "url": obj.get("url"),
            "archive_url": obj.get("archive_url"),
            "assignees_url": obj.get("assignees_url"),
            "blobs_url": obj.get("blobs_url"),
            "branches_url": obj.get("branches_url"),
            "collaborators_url": obj.get("collaborators_url"),
            "comments_url": obj.get("comments_url"),
            "commits_url": obj.get("commits_url"),
            "compare_url": obj.get("compare_url"),
            "contents_url": obj.get("contents_url"),
            "contributors_url": obj.get("contributors_url"),
            "deployments_url": obj.get("deployments_url"),
            "downloads_url": obj.get("downloads_url"),
            "events_url": obj.get("events_url"),
            "forks_url": obj.get("forks_url"),
            "git_commits_url": obj.get("git_commits_url"),
            "git_refs_url": obj.get("git_refs_url"),
            "git_tags_url": obj.get("git_tags_url"),
            "issue_comment_url": obj.get("issue_comment_url"),
            "issue_events_url": obj.get("issue_events_url"),
            "issues_url": obj.get("issues_url"),
            "keys_url": obj.get("keys_url"),
            "labels_url": obj.get("labels_url"),
            "languages_url": obj.get("languages_url"),
            "merges_url": obj.get("merges_url"),
            "milestones_url": obj.get("milestones_url"),
            "notifications_url": obj.get("notifications_url"),
            "pulls_url": obj.get("pulls_url"),
            "releases_url": obj.get("releases_url"),
            "stargazers_url": obj.get("stargazers_url"),
            "statuses_url": obj.get("statuses_url"),
            "subscribers_url": obj.get("subscribers_url"),
            "subscription_url": obj.get("subscription_url"),
            "tags_url": obj.get("tags_url"),
            "teams_url": obj.get("teams_url"),
            "trees_url": obj.get("trees_url"),
            "hooks_url": obj.get("hooks_url")
        })
        return _obj


