# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from typing import Optional, Set
from typing_extensions import Self

class OrganizationRole(BaseModel):
    """
    Organization roles
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier of the role.")
    name: StrictStr = Field(description="The name of the role.")
    description: Optional[StrictStr] = Field(default=None, description="A short description about who this role is for or what permissions it grants.")
    base_role: Optional[StrictStr] = Field(default=None, description="The system role from which this role inherits permissions.")
    source: Optional[StrictStr] = Field(default=None, description="Source answers the question, \"where did this role come from?\"")
    permissions: List[StrictStr] = Field(description="A list of permissions included in this role.")
    organization: Optional[NullableSimpleUser]
    created_at: datetime = Field(description="The date and time the role was created.")
    updated_at: datetime = Field(description="The date and time the role was last updated.")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "base_role", "source", "permissions", "organization", "created_at", "updated_at"]

    @field_validator('base_role')
    def base_role_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'triage', 'write', 'maintain', 'admin']):
            raise ValueError("must be one of enum values ('read', 'triage', 'write', 'maintain', 'admin')")
        return value

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Organization', 'Enterprise', 'Predefined']):
            raise ValueError("must be one of enum values ('Organization', 'Enterprise', 'Predefined')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if base_role (nullable) is None
        # and model_fields_set contains the field
        if self.base_role is None and "base_role" in self.model_fields_set:
            _dict['base_role'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if organization (nullable) is None
        # and model_fields_set contains the field
        if self.organization is None and "organization" in self.model_fields_set:
            _dict['organization'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "base_role": obj.get("base_role"),
            "source": obj.get("source"),
            "permissions": obj.get("permissions"),
            "organization": NullableSimpleUser.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


