# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.nullable_secret_scanning_first_detected_location import NullableSecretScanningFirstDetectedLocation
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.secret_scanning_alert_resolution import SecretScanningAlertResolution
from devopso.clients.github.models.secret_scanning_alert_state import SecretScanningAlertState
from devopso.clients.github.models.simple_repository import SimpleRepository
from typing import Optional, Set
from typing_extensions import Self

class OrganizationSecretScanningAlert(BaseModel):
    """
    OrganizationSecretScanningAlert
    """ # noqa: E501
    number: Optional[StrictInt] = Field(default=None, description="The security alert number.")
    created_at: Optional[datetime] = Field(default=None, description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    updated_at: Optional[datetime] = Field(default=None, description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    url: Optional[StrictStr] = Field(default=None, description="The REST API URL of the alert resource.")
    html_url: Optional[StrictStr] = Field(default=None, description="The GitHub URL of the alert resource.")
    locations_url: Optional[StrictStr] = Field(default=None, description="The REST API URL of the code locations for this alert.")
    state: Optional[SecretScanningAlertState] = None
    resolution: Optional[SecretScanningAlertResolution] = None
    resolved_at: Optional[datetime] = Field(default=None, description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    resolved_by: Optional[NullableSimpleUser] = None
    secret_type: Optional[StrictStr] = Field(default=None, description="The type of secret that secret scanning detected.")
    secret_type_display_name: Optional[StrictStr] = Field(default=None, description="User-friendly name for the detected secret, matching the `secret_type`. For a list of built-in patterns, see \"[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets).\"")
    secret: Optional[StrictStr] = Field(default=None, description="The secret that was detected.")
    repository: Optional[SimpleRepository] = None
    push_protection_bypassed: Optional[StrictBool] = Field(default=None, description="Whether push protection was bypassed for the detected secret.")
    push_protection_bypassed_by: Optional[NullableSimpleUser] = None
    push_protection_bypassed_at: Optional[datetime] = Field(default=None, description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    push_protection_bypass_request_reviewer: Optional[NullableSimpleUser] = None
    push_protection_bypass_request_reviewer_comment: Optional[StrictStr] = Field(default=None, description="An optional comment when reviewing a push protection bypass.")
    push_protection_bypass_request_comment: Optional[StrictStr] = Field(default=None, description="An optional comment when requesting a push protection bypass.")
    push_protection_bypass_request_html_url: Optional[StrictStr] = Field(default=None, description="The URL to a push protection bypass request.")
    resolution_comment: Optional[StrictStr] = Field(default=None, description="The comment that was optionally added when this alert was closed")
    validity: Optional[StrictStr] = Field(default=None, description="The token status as of the latest validity check.")
    publicly_leaked: Optional[StrictBool] = Field(default=None, description="Whether the secret was publicly leaked.")
    multi_repo: Optional[StrictBool] = Field(default=None, description="Whether the detected secret was found in multiple repositories in the same organization or enterprise.")
    is_base64_encoded: Optional[StrictBool] = Field(default=None, description="A boolean value representing whether or not alert is base64 encoded")
    first_location_detected: Optional[NullableSecretScanningFirstDetectedLocation] = None
    has_more_locations: Optional[StrictBool] = Field(default=None, description="A boolean value representing whether or not the token in the alert was detected in more than one location.")
    assigned_to: Optional[NullableSimpleUser] = None
    __properties: ClassVar[List[str]] = ["number", "created_at", "updated_at", "url", "html_url", "locations_url", "state", "resolution", "resolved_at", "resolved_by", "secret_type", "secret_type_display_name", "secret", "repository", "push_protection_bypassed", "push_protection_bypassed_by", "push_protection_bypassed_at", "push_protection_bypass_request_reviewer", "push_protection_bypass_request_reviewer_comment", "push_protection_bypass_request_comment", "push_protection_bypass_request_html_url", "resolution_comment", "validity", "publicly_leaked", "multi_repo", "is_base64_encoded", "first_location_detected", "has_more_locations", "assigned_to"]

    @field_validator('validity')
    def validity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['active', 'inactive', 'unknown']):
            raise ValueError("must be one of enum values ('active', 'inactive', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationSecretScanningAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "number",
            "created_at",
            "updated_at",
            "url",
            "html_url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resolved_by
        if self.resolved_by:
            _dict['resolved_by'] = self.resolved_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of push_protection_bypassed_by
        if self.push_protection_bypassed_by:
            _dict['push_protection_bypassed_by'] = self.push_protection_bypassed_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of push_protection_bypass_request_reviewer
        if self.push_protection_bypass_request_reviewer:
            _dict['push_protection_bypass_request_reviewer'] = self.push_protection_bypass_request_reviewer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of first_location_detected
        if self.first_location_detected:
            _dict['first_location_detected'] = self.first_location_detected.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assigned_to
        if self.assigned_to:
            _dict['assigned_to'] = self.assigned_to.to_dict()
        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if resolution (nullable) is None
        # and model_fields_set contains the field
        if self.resolution is None and "resolution" in self.model_fields_set:
            _dict['resolution'] = None

        # set to None if resolved_at (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_at is None and "resolved_at" in self.model_fields_set:
            _dict['resolved_at'] = None

        # set to None if resolved_by (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_by is None and "resolved_by" in self.model_fields_set:
            _dict['resolved_by'] = None

        # set to None if push_protection_bypassed (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypassed is None and "push_protection_bypassed" in self.model_fields_set:
            _dict['push_protection_bypassed'] = None

        # set to None if push_protection_bypassed_by (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypassed_by is None and "push_protection_bypassed_by" in self.model_fields_set:
            _dict['push_protection_bypassed_by'] = None

        # set to None if push_protection_bypassed_at (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypassed_at is None and "push_protection_bypassed_at" in self.model_fields_set:
            _dict['push_protection_bypassed_at'] = None

        # set to None if push_protection_bypass_request_reviewer (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypass_request_reviewer is None and "push_protection_bypass_request_reviewer" in self.model_fields_set:
            _dict['push_protection_bypass_request_reviewer'] = None

        # set to None if push_protection_bypass_request_reviewer_comment (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypass_request_reviewer_comment is None and "push_protection_bypass_request_reviewer_comment" in self.model_fields_set:
            _dict['push_protection_bypass_request_reviewer_comment'] = None

        # set to None if push_protection_bypass_request_comment (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypass_request_comment is None and "push_protection_bypass_request_comment" in self.model_fields_set:
            _dict['push_protection_bypass_request_comment'] = None

        # set to None if push_protection_bypass_request_html_url (nullable) is None
        # and model_fields_set contains the field
        if self.push_protection_bypass_request_html_url is None and "push_protection_bypass_request_html_url" in self.model_fields_set:
            _dict['push_protection_bypass_request_html_url'] = None

        # set to None if resolution_comment (nullable) is None
        # and model_fields_set contains the field
        if self.resolution_comment is None and "resolution_comment" in self.model_fields_set:
            _dict['resolution_comment'] = None

        # set to None if publicly_leaked (nullable) is None
        # and model_fields_set contains the field
        if self.publicly_leaked is None and "publicly_leaked" in self.model_fields_set:
            _dict['publicly_leaked'] = None

        # set to None if multi_repo (nullable) is None
        # and model_fields_set contains the field
        if self.multi_repo is None and "multi_repo" in self.model_fields_set:
            _dict['multi_repo'] = None

        # set to None if is_base64_encoded (nullable) is None
        # and model_fields_set contains the field
        if self.is_base64_encoded is None and "is_base64_encoded" in self.model_fields_set:
            _dict['is_base64_encoded'] = None

        # set to None if first_location_detected (nullable) is None
        # and model_fields_set contains the field
        if self.first_location_detected is None and "first_location_detected" in self.model_fields_set:
            _dict['first_location_detected'] = None

        # set to None if assigned_to (nullable) is None
        # and model_fields_set contains the field
        if self.assigned_to is None and "assigned_to" in self.model_fields_set:
            _dict['assigned_to'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationSecretScanningAlert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "locations_url": obj.get("locations_url"),
            "state": obj.get("state"),
            "resolution": obj.get("resolution"),
            "resolved_at": obj.get("resolved_at"),
            "resolved_by": NullableSimpleUser.from_dict(obj["resolved_by"]) if obj.get("resolved_by") is not None else None,
            "secret_type": obj.get("secret_type"),
            "secret_type_display_name": obj.get("secret_type_display_name"),
            "secret": obj.get("secret"),
            "repository": SimpleRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "push_protection_bypassed": obj.get("push_protection_bypassed"),
            "push_protection_bypassed_by": NullableSimpleUser.from_dict(obj["push_protection_bypassed_by"]) if obj.get("push_protection_bypassed_by") is not None else None,
            "push_protection_bypassed_at": obj.get("push_protection_bypassed_at"),
            "push_protection_bypass_request_reviewer": NullableSimpleUser.from_dict(obj["push_protection_bypass_request_reviewer"]) if obj.get("push_protection_bypass_request_reviewer") is not None else None,
            "push_protection_bypass_request_reviewer_comment": obj.get("push_protection_bypass_request_reviewer_comment"),
            "push_protection_bypass_request_comment": obj.get("push_protection_bypass_request_comment"),
            "push_protection_bypass_request_html_url": obj.get("push_protection_bypass_request_html_url"),
            "resolution_comment": obj.get("resolution_comment"),
            "validity": obj.get("validity"),
            "publicly_leaked": obj.get("publicly_leaked"),
            "multi_repo": obj.get("multi_repo"),
            "is_base64_encoded": obj.get("is_base64_encoded"),
            "first_location_detected": NullableSecretScanningFirstDetectedLocation.from_dict(obj["first_location_detected"]) if obj.get("first_location_detected") is not None else None,
            "has_more_locations": obj.get("has_more_locations"),
            "assigned_to": NullableSimpleUser.from_dict(obj["assigned_to"]) if obj.get("assigned_to") is not None else None
        })
        return _obj


