# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class OrgsCreateArtifactStorageRecordRequest(BaseModel):
    """
    OrgsCreateArtifactStorageRecordRequest
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The name of the artifact.")
    digest: Annotated[str, Field(min_length=71, strict=True, max_length=71)] = Field(description="The digest of the artifact (algorithm:hex-encoded-digest).")
    artifact_url: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The URL where the artifact is stored.")
    path: Optional[StrictStr] = Field(default=None, description="The path of the artifact.")
    registry_url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The base URL of the artifact registry.")
    repository: Optional[StrictStr] = Field(default=None, description="The repository name within the registry.")
    status: Optional[StrictStr] = Field(default='active', description="The status of the artifact (e.g., active, inactive).")
    __properties: ClassVar[List[str]] = ["name", "digest", "artifact_url", "path", "registry_url", "repository", "status"]

    @field_validator('digest')
    def digest_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^sha256:[a-f0-9]{64}$", value):
            raise ValueError(r"must validate the regular expression /^sha256:[a-f0-9]{64}$/")
        return value

    @field_validator('artifact_url')
    def artifact_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^https:\/\/", value):
            raise ValueError(r"must validate the regular expression /^https:\/\//")
        return value

    @field_validator('registry_url')
    def registry_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^https:\/\/", value):
            raise ValueError(r"must validate the regular expression /^https:\/\//")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['active', 'eol', 'deleted']):
            raise ValueError("must be one of enum values ('active', 'eol', 'deleted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrgsCreateArtifactStorageRecordRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrgsCreateArtifactStorageRecordRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "digest": obj.get("digest"),
            "artifact_url": obj.get("artifact_url"),
            "path": obj.get("path"),
            "registry_url": obj.get("registry_url"),
            "repository": obj.get("repository"),
            "status": obj.get("status") if obj.get("status") is not None else 'active'
        })
        return _obj


