# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OrgsUpdateRequest(BaseModel):
    """
    OrgsUpdateRequest
    """ # noqa: E501
    billing_email: Optional[StrictStr] = Field(default=None, description="Billing email address. This address is not publicized.")
    company: Optional[StrictStr] = Field(default=None, description="The company name.")
    email: Optional[StrictStr] = Field(default=None, description="The publicly visible email address.")
    twitter_username: Optional[StrictStr] = Field(default=None, description="The Twitter username of the company.")
    location: Optional[StrictStr] = Field(default=None, description="The location.")
    name: Optional[StrictStr] = Field(default=None, description="The shorthand name of the company.")
    description: Optional[StrictStr] = Field(default=None, description="The description of the company. The maximum size is 160 characters.")
    has_organization_projects: Optional[StrictBool] = Field(default=None, description="Whether an organization can use organization projects.")
    has_repository_projects: Optional[StrictBool] = Field(default=None, description="Whether repositories that belong to the organization can use repository projects.")
    default_repository_permission: Optional[StrictStr] = Field(default='read', description="Default permission level members have for organization repositories.")
    members_can_create_repositories: Optional[StrictBool] = Field(default=True, description="Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.")
    members_can_create_internal_repositories: Optional[StrictBool] = Field(default=None, description="Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.")
    members_can_create_private_repositories: Optional[StrictBool] = Field(default=None, description="Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.")
    members_can_create_public_repositories: Optional[StrictBool] = Field(default=None, description="Whether organization members can create public repositories, which are visible to anyone. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.")
    members_allowed_repository_creation_type: Optional[StrictStr] = Field(default=None, description="Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud.  **Note:** This parameter is closing down and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.")
    members_can_create_pages: Optional[StrictBool] = Field(default=True, description="Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.")
    members_can_create_public_pages: Optional[StrictBool] = Field(default=True, description="Whether organization members can create public GitHub Pages sites. Existing published sites will not be impacted.")
    members_can_create_private_pages: Optional[StrictBool] = Field(default=True, description="Whether organization members can create private GitHub Pages sites. Existing published sites will not be impacted.")
    members_can_fork_private_repositories: Optional[StrictBool] = Field(default=False, description="Whether organization members can fork private organization repositories.")
    web_commit_signoff_required: Optional[StrictBool] = Field(default=False, description="Whether contributors to organization repositories are required to sign off on commits they make through GitHub's web interface.")
    blog: Optional[StrictStr] = None
    advanced_security_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    dependabot_alerts_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether Dependabot alerts are automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    dependabot_security_updates_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether Dependabot security updates are automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    dependency_graph_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether dependency graph is automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    secret_scanning_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether secret scanning is automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    secret_scanning_push_protection_enabled_for_new_repositories: Optional[StrictBool] = Field(default=None, description="**Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.  Whether secret scanning push protection is automatically enabled for new repositories and repositories transferred to this organization.  To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"  You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.")
    secret_scanning_push_protection_custom_link_enabled: Optional[StrictBool] = Field(default=None, description="Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.")
    secret_scanning_push_protection_custom_link: Optional[StrictStr] = Field(default=None, description="If `secret_scanning_push_protection_custom_link_enabled` is true, the URL that will be displayed to contributors who are blocked from pushing a secret.")
    deploy_keys_enabled_for_repositories: Optional[StrictBool] = Field(default=None, description="Controls whether or not deploy keys may be added and used for repositories in the organization.")
    __properties: ClassVar[List[str]] = ["billing_email", "company", "email", "twitter_username", "location", "name", "description", "has_organization_projects", "has_repository_projects", "default_repository_permission", "members_can_create_repositories", "members_can_create_internal_repositories", "members_can_create_private_repositories", "members_can_create_public_repositories", "members_allowed_repository_creation_type", "members_can_create_pages", "members_can_create_public_pages", "members_can_create_private_pages", "members_can_fork_private_repositories", "web_commit_signoff_required", "blog", "advanced_security_enabled_for_new_repositories", "dependabot_alerts_enabled_for_new_repositories", "dependabot_security_updates_enabled_for_new_repositories", "dependency_graph_enabled_for_new_repositories", "secret_scanning_enabled_for_new_repositories", "secret_scanning_push_protection_enabled_for_new_repositories", "secret_scanning_push_protection_custom_link_enabled", "secret_scanning_push_protection_custom_link", "deploy_keys_enabled_for_repositories"]

    @field_validator('default_repository_permission')
    def default_repository_permission_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['read', 'write', 'admin', 'none']):
            raise ValueError("must be one of enum values ('read', 'write', 'admin', 'none')")
        return value

    @field_validator('members_allowed_repository_creation_type')
    def members_allowed_repository_creation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['all', 'private', 'none']):
            raise ValueError("must be one of enum values ('all', 'private', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrgsUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrgsUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "billing_email": obj.get("billing_email"),
            "company": obj.get("company"),
            "email": obj.get("email"),
            "twitter_username": obj.get("twitter_username"),
            "location": obj.get("location"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "has_organization_projects": obj.get("has_organization_projects"),
            "has_repository_projects": obj.get("has_repository_projects"),
            "default_repository_permission": obj.get("default_repository_permission") if obj.get("default_repository_permission") is not None else 'read',
            "members_can_create_repositories": obj.get("members_can_create_repositories") if obj.get("members_can_create_repositories") is not None else True,
            "members_can_create_internal_repositories": obj.get("members_can_create_internal_repositories"),
            "members_can_create_private_repositories": obj.get("members_can_create_private_repositories"),
            "members_can_create_public_repositories": obj.get("members_can_create_public_repositories"),
            "members_allowed_repository_creation_type": obj.get("members_allowed_repository_creation_type"),
            "members_can_create_pages": obj.get("members_can_create_pages") if obj.get("members_can_create_pages") is not None else True,
            "members_can_create_public_pages": obj.get("members_can_create_public_pages") if obj.get("members_can_create_public_pages") is not None else True,
            "members_can_create_private_pages": obj.get("members_can_create_private_pages") if obj.get("members_can_create_private_pages") is not None else True,
            "members_can_fork_private_repositories": obj.get("members_can_fork_private_repositories") if obj.get("members_can_fork_private_repositories") is not None else False,
            "web_commit_signoff_required": obj.get("web_commit_signoff_required") if obj.get("web_commit_signoff_required") is not None else False,
            "blog": obj.get("blog"),
            "advanced_security_enabled_for_new_repositories": obj.get("advanced_security_enabled_for_new_repositories"),
            "dependabot_alerts_enabled_for_new_repositories": obj.get("dependabot_alerts_enabled_for_new_repositories"),
            "dependabot_security_updates_enabled_for_new_repositories": obj.get("dependabot_security_updates_enabled_for_new_repositories"),
            "dependency_graph_enabled_for_new_repositories": obj.get("dependency_graph_enabled_for_new_repositories"),
            "secret_scanning_enabled_for_new_repositories": obj.get("secret_scanning_enabled_for_new_repositories"),
            "secret_scanning_push_protection_enabled_for_new_repositories": obj.get("secret_scanning_push_protection_enabled_for_new_repositories"),
            "secret_scanning_push_protection_custom_link_enabled": obj.get("secret_scanning_push_protection_custom_link_enabled"),
            "secret_scanning_push_protection_custom_link": obj.get("secret_scanning_push_protection_custom_link"),
            "deploy_keys_enabled_for_repositories": obj.get("deploy_keys_enabled_for_repositories")
        })
        return _obj


