# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.container_metadata import ContainerMetadata
from devopso.clients.github.models.docker_metadata import DockerMetadata
from typing import Optional, Set
from typing_extensions import Self

class PackageVersionMetadata(BaseModel):
    """
    PackageVersionMetadata
    """ # noqa: E501
    package_type: StrictStr
    container: Optional[ContainerMetadata] = None
    docker: Optional[DockerMetadata] = None
    __properties: ClassVar[List[str]] = ["package_type", "container", "docker"]

    @field_validator('package_type')
    def package_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['npm', 'maven', 'rubygems', 'docker', 'nuget', 'container']):
            raise ValueError("must be one of enum values ('npm', 'maven', 'rubygems', 'docker', 'nuget', 'container')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PackageVersionMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container
        if self.container:
            _dict['container'] = self.container.to_dict()
        # override the default output from pydantic by calling `to_dict()` of docker
        if self.docker:
            _dict['docker'] = self.docker.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PackageVersionMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "package_type": obj.get("package_type"),
            "container": ContainerMetadata.from_dict(obj["container"]) if obj.get("container") is not None else None,
            "docker": DockerMetadata.from_dict(obj["docker"]) if obj.get("docker") is not None else None
        })
        return _obj


