# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.pages_https_certificate import PagesHttpsCertificate
from devopso.clients.github.models.pages_source_hash import PagesSourceHash
from typing import Optional, Set
from typing_extensions import Self

class Page(BaseModel):
    """
    The configuration for GitHub Pages for a repository.
    """ # noqa: E501
    url: StrictStr = Field(description="The API address for accessing this Page resource.")
    status: Optional[StrictStr] = Field(description="The status of the most recent build of the Page.")
    cname: Optional[StrictStr] = Field(description="The Pages site's custom domain")
    protected_domain_state: Optional[StrictStr] = Field(default=None, description="The state if the domain is verified")
    pending_domain_unverified_at: Optional[datetime] = Field(default=None, description="The timestamp when a pending domain becomes unverified.")
    custom_404: StrictBool = Field(description="Whether the Page has a custom 404 page.")
    html_url: Optional[StrictStr] = Field(default=None, description="The web address the Page can be accessed from.")
    build_type: Optional[StrictStr] = Field(default=None, description="The process in which the Page will be built.")
    source: Optional[PagesSourceHash] = None
    public: StrictBool = Field(description="Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.")
    https_certificate: Optional[PagesHttpsCertificate] = None
    https_enforced: Optional[StrictBool] = Field(default=None, description="Whether https is enabled on the domain")
    __properties: ClassVar[List[str]] = ["url", "status", "cname", "protected_domain_state", "pending_domain_unverified_at", "custom_404", "html_url", "build_type", "source", "public", "https_certificate", "https_enforced"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['built', 'building', 'errored']):
            raise ValueError("must be one of enum values ('built', 'building', 'errored')")
        return value

    @field_validator('protected_domain_state')
    def protected_domain_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'verified', 'unverified']):
            raise ValueError("must be one of enum values ('pending', 'verified', 'unverified')")
        return value

    @field_validator('build_type')
    def build_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['legacy', 'workflow']):
            raise ValueError("must be one of enum values ('legacy', 'workflow')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Page from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of https_certificate
        if self.https_certificate:
            _dict['https_certificate'] = self.https_certificate.to_dict()
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if cname (nullable) is None
        # and model_fields_set contains the field
        if self.cname is None and "cname" in self.model_fields_set:
            _dict['cname'] = None

        # set to None if protected_domain_state (nullable) is None
        # and model_fields_set contains the field
        if self.protected_domain_state is None and "protected_domain_state" in self.model_fields_set:
            _dict['protected_domain_state'] = None

        # set to None if pending_domain_unverified_at (nullable) is None
        # and model_fields_set contains the field
        if self.pending_domain_unverified_at is None and "pending_domain_unverified_at" in self.model_fields_set:
            _dict['pending_domain_unverified_at'] = None

        # set to None if build_type (nullable) is None
        # and model_fields_set contains the field
        if self.build_type is None and "build_type" in self.model_fields_set:
            _dict['build_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Page from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "status": obj.get("status"),
            "cname": obj.get("cname"),
            "protected_domain_state": obj.get("protected_domain_state"),
            "pending_domain_unverified_at": obj.get("pending_domain_unverified_at"),
            "custom_404": obj.get("custom_404") if obj.get("custom_404") is not None else False,
            "html_url": obj.get("html_url"),
            "build_type": obj.get("build_type"),
            "source": PagesSourceHash.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "public": obj.get("public"),
            "https_certificate": PagesHttpsCertificate.from_dict(obj["https_certificate"]) if obj.get("https_certificate") is not None else None,
            "https_enforced": obj.get("https_enforced")
        })
        return _obj


