# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.pending_deployment_environment import PendingDeploymentEnvironment
from devopso.clients.github.models.pending_deployment_reviewers_inner import PendingDeploymentReviewersInner
from typing import Optional, Set
from typing_extensions import Self

class PendingDeployment(BaseModel):
    """
    Details of a deployment that is waiting for protection rules to pass
    """ # noqa: E501
    environment: PendingDeploymentEnvironment
    wait_timer: StrictInt = Field(description="The set duration of the wait timer")
    wait_timer_started_at: Optional[datetime] = Field(description="The time that the wait timer began.")
    current_user_can_approve: StrictBool = Field(description="Whether the currently authenticated user can approve the deployment")
    reviewers: List[PendingDeploymentReviewersInner] = Field(description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.")
    __properties: ClassVar[List[str]] = ["environment", "wait_timer", "wait_timer_started_at", "current_user_can_approve", "reviewers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PendingDeployment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reviewers (list)
        _items = []
        if self.reviewers:
            for _item_reviewers in self.reviewers:
                if _item_reviewers:
                    _items.append(_item_reviewers.to_dict())
            _dict['reviewers'] = _items
        # set to None if wait_timer_started_at (nullable) is None
        # and model_fields_set contains the field
        if self.wait_timer_started_at is None and "wait_timer_started_at" in self.model_fields_set:
            _dict['wait_timer_started_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PendingDeployment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "environment": PendingDeploymentEnvironment.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "wait_timer": obj.get("wait_timer"),
            "wait_timer_started_at": obj.get("wait_timer_started_at"),
            "current_user_can_approve": obj.get("current_user_can_approve"),
            "reviewers": [PendingDeploymentReviewersInner.from_dict(_item) for _item in obj["reviewers"]] if obj.get("reviewers") is not None else None
        })
        return _obj


