# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.personal_access_token_request_permissions_added import PersonalAccessTokenRequestPermissionsAdded
from devopso.clients.github.models.personal_access_token_request_permissions_result import PersonalAccessTokenRequestPermissionsResult
from devopso.clients.github.models.personal_access_token_request_permissions_upgraded import PersonalAccessTokenRequestPermissionsUpgraded
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.webhooks_repositories_inner import WebhooksRepositoriesInner
from typing import Optional, Set
from typing_extensions import Self

class PersonalAccessTokenRequest(BaseModel):
    """
    Details of a Personal Access Token Request.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the request for access via fine-grained personal access token. Used as the `pat_request_id` parameter in the list and review API calls.")
    owner: SimpleUser
    permissions_added: PersonalAccessTokenRequestPermissionsAdded
    permissions_upgraded: PersonalAccessTokenRequestPermissionsUpgraded
    permissions_result: PersonalAccessTokenRequestPermissionsResult
    repository_selection: StrictStr = Field(description="Type of repository selection requested.")
    repository_count: Optional[StrictInt] = Field(description="The number of repositories the token is requesting access to. This field is only populated when `repository_selection` is `subset`.")
    repositories: Optional[List[WebhooksRepositoriesInner]] = Field(description="An array of repository objects the token is requesting access to. This field is only populated when `repository_selection` is `subset`.")
    created_at: StrictStr = Field(description="Date and time when the request for access was created.")
    token_id: StrictInt = Field(description="Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants.")
    token_name: StrictStr = Field(description="The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens.")
    token_expired: StrictBool = Field(description="Whether the associated fine-grained personal access token has expired.")
    token_expires_at: Optional[StrictStr] = Field(description="Date and time when the associated fine-grained personal access token expires.")
    token_last_used_at: Optional[StrictStr] = Field(description="Date and time when the associated fine-grained personal access token was last used for authentication.")
    __properties: ClassVar[List[str]] = ["id", "owner", "permissions_added", "permissions_upgraded", "permissions_result", "repository_selection", "repository_count", "repositories", "created_at", "token_id", "token_name", "token_expired", "token_expires_at", "token_last_used_at"]

    @field_validator('repository_selection')
    def repository_selection_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['none', 'all', 'subset']):
            raise ValueError("must be one of enum values ('none', 'all', 'subset')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonalAccessTokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions_added
        if self.permissions_added:
            _dict['permissions_added'] = self.permissions_added.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions_upgraded
        if self.permissions_upgraded:
            _dict['permissions_upgraded'] = self.permissions_upgraded.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions_result
        if self.permissions_result:
            _dict['permissions_result'] = self.permissions_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in repositories (list)
        _items = []
        if self.repositories:
            for _item_repositories in self.repositories:
                if _item_repositories:
                    _items.append(_item_repositories.to_dict())
            _dict['repositories'] = _items
        # set to None if repository_count (nullable) is None
        # and model_fields_set contains the field
        if self.repository_count is None and "repository_count" in self.model_fields_set:
            _dict['repository_count'] = None

        # set to None if repositories (nullable) is None
        # and model_fields_set contains the field
        if self.repositories is None and "repositories" in self.model_fields_set:
            _dict['repositories'] = None

        # set to None if token_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.token_expires_at is None and "token_expires_at" in self.model_fields_set:
            _dict['token_expires_at'] = None

        # set to None if token_last_used_at (nullable) is None
        # and model_fields_set contains the field
        if self.token_last_used_at is None and "token_last_used_at" in self.model_fields_set:
            _dict['token_last_used_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonalAccessTokenRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "owner": SimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "permissions_added": PersonalAccessTokenRequestPermissionsAdded.from_dict(obj["permissions_added"]) if obj.get("permissions_added") is not None else None,
            "permissions_upgraded": PersonalAccessTokenRequestPermissionsUpgraded.from_dict(obj["permissions_upgraded"]) if obj.get("permissions_upgraded") is not None else None,
            "permissions_result": PersonalAccessTokenRequestPermissionsResult.from_dict(obj["permissions_result"]) if obj.get("permissions_result") is not None else None,
            "repository_selection": obj.get("repository_selection"),
            "repository_count": obj.get("repository_count"),
            "repositories": [WebhooksRepositoriesInner.from_dict(_item) for _item in obj["repositories"]] if obj.get("repositories") is not None else None,
            "created_at": obj.get("created_at"),
            "token_id": obj.get("token_id"),
            "token_name": obj.get("token_name"),
            "token_expired": obj.get("token_expired"),
            "token_expires_at": obj.get("token_expires_at"),
            "token_last_used_at": obj.get("token_last_used_at")
        })
        return _obj


