# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PrivateRegistriesUpdateOrgPrivateRegistryRequest(BaseModel):
    """
    PrivateRegistriesUpdateOrgPrivateRegistryRequest
    """ # noqa: E501
    registry_type: Optional[StrictStr] = Field(default=None, description="The registry type.")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the private registry.")
    username: Optional[StrictStr] = Field(default=None, description="The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.")
    encrypted_value: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.")
    key_id: Optional[StrictStr] = Field(default=None, description="The ID of the key you used to encrypt the secret.")
    visibility: Optional[StrictStr] = Field(default=None, description="Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.")
    selected_repository_ids: Optional[List[StrictInt]] = Field(default=None, description="An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. This field should be omitted if `visibility` is set to `all` or `private`.")
    __properties: ClassVar[List[str]] = ["registry_type", "url", "username", "encrypted_value", "key_id", "visibility", "selected_repository_ids"]

    @field_validator('registry_type')
    def registry_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['maven_repository', 'nuget_feed', 'goproxy_server', 'npm_registry', 'rubygems_server', 'cargo_registry', 'composer_repository', 'docker_registry', 'git_source', 'helm_registry', 'hex_organization', 'hex_repository', 'pub_repository', 'python_index', 'terraform_registry']):
            raise ValueError("must be one of enum values ('maven_repository', 'nuget_feed', 'goproxy_server', 'npm_registry', 'rubygems_server', 'cargo_registry', 'composer_repository', 'docker_registry', 'git_source', 'helm_registry', 'hex_organization', 'hex_repository', 'pub_repository', 'python_index', 'terraform_registry')")
        return value

    @field_validator('encrypted_value')
    def encrypted_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$", value):
            raise ValueError(r"must validate the regular expression /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$/")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['all', 'private', 'selected']):
            raise ValueError("must be one of enum values ('all', 'private', 'selected')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateRegistriesUpdateOrgPrivateRegistryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateRegistriesUpdateOrgPrivateRegistryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "registry_type": obj.get("registry_type"),
            "url": obj.get("url"),
            "username": obj.get("username"),
            "encrypted_value": obj.get("encrypted_value"),
            "key_id": obj.get("key_id"),
            "visibility": obj.get("visibility"),
            "selected_repository_ids": obj.get("selected_repository_ids")
        })
        return _obj


