# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.repository_advisory_create_vulnerabilities_inner import RepositoryAdvisoryCreateVulnerabilitiesInner
from typing import Optional, Set
from typing_extensions import Self

class PrivateVulnerabilityReportCreate(BaseModel):
    """
    PrivateVulnerabilityReportCreate
    """ # noqa: E501
    summary: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="A short summary of the advisory.")
    description: Annotated[str, Field(strict=True, max_length=65535)] = Field(description="A detailed description of what the advisory impacts.")
    vulnerabilities: Optional[List[RepositoryAdvisoryCreateVulnerabilitiesInner]] = Field(default=None, description="An array of products affected by the vulnerability detailed in a repository security advisory.")
    cwe_ids: Optional[List[StrictStr]] = Field(default=None, description="A list of Common Weakness Enumeration (CWE) IDs.")
    severity: Optional[StrictStr] = Field(default=None, description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.")
    cvss_vector_string: Optional[StrictStr] = Field(default=None, description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.")
    start_private_fork: Optional[StrictBool] = Field(default=False, description="Whether to create a temporary private fork of the repository to collaborate on a fix.")
    __properties: ClassVar[List[str]] = ["summary", "description", "vulnerabilities", "cwe_ids", "severity", "cvss_vector_string", "start_private_fork"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['critical', 'high', 'medium', 'low']):
            raise ValueError("must be one of enum values ('critical', 'high', 'medium', 'low')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivateVulnerabilityReportCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # set to None if vulnerabilities (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerabilities is None and "vulnerabilities" in self.model_fields_set:
            _dict['vulnerabilities'] = None

        # set to None if cwe_ids (nullable) is None
        # and model_fields_set contains the field
        if self.cwe_ids is None and "cwe_ids" in self.model_fields_set:
            _dict['cwe_ids'] = None

        # set to None if severity (nullable) is None
        # and model_fields_set contains the field
        if self.severity is None and "severity" in self.model_fields_set:
            _dict['severity'] = None

        # set to None if cvss_vector_string (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_vector_string is None and "cvss_vector_string" in self.model_fields_set:
            _dict['cvss_vector_string'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivateVulnerabilityReportCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "vulnerabilities": [RepositoryAdvisoryCreateVulnerabilitiesInner.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "cwe_ids": obj.get("cwe_ids"),
            "severity": obj.get("severity"),
            "cvss_vector_string": obj.get("cvss_vector_string"),
            "start_private_fork": obj.get("start_private_fork") if obj.get("start_private_fork") is not None else False
        })
        return _obj


