# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.projects_v2_field_configuration import ProjectsV2FieldConfiguration
from devopso.clients.github.models.projects_v2_single_select_options import ProjectsV2SingleSelectOptions
from typing import Optional, Set
from typing_extensions import Self

class ProjectsV2Field(BaseModel):
    """
    A field inside a projects v2 project
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier of the field.")
    node_id: Optional[StrictStr] = Field(default=None, description="The node ID of the field.")
    project_url: StrictStr = Field(description="The API URL of the project that contains the field.")
    name: StrictStr = Field(description="The name of the field.")
    data_type: StrictStr = Field(description="The field's data type.")
    options: Optional[List[ProjectsV2SingleSelectOptions]] = Field(default=None, description="The options available for single select fields.")
    configuration: Optional[ProjectsV2FieldConfiguration] = None
    created_at: datetime = Field(description="The time when the field was created.")
    updated_at: datetime = Field(description="The time when the field was last updated.")
    __properties: ClassVar[List[str]] = ["id", "node_id", "project_url", "name", "data_type", "options", "configuration", "created_at", "updated_at"]

    @field_validator('data_type')
    def data_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['assignees', 'linked_pull_requests', 'reviewers', 'labels', 'milestone', 'repository', 'title', 'text', 'single_select', 'number', 'date', 'iteration', 'issue_type', 'parent_issue', 'sub_issues_progress']):
            raise ValueError("must be one of enum values ('assignees', 'linked_pull_requests', 'reviewers', 'labels', 'milestone', 'repository', 'title', 'text', 'single_select', 'number', 'date', 'iteration', 'issue_type', 'parent_issue', 'sub_issues_progress')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectsV2Field from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item_options in self.options:
                if _item_options:
                    _items.append(_item_options.to_dict())
            _dict['options'] = _items
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict['configuration'] = self.configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectsV2Field from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "project_url": obj.get("project_url"),
            "name": obj.get("name"),
            "data_type": obj.get("data_type"),
            "options": [ProjectsV2SingleSelectOptions.from_dict(_item) for _item in obj["options"]] if obj.get("options") is not None else None,
            "configuration": ProjectsV2FieldConfiguration.from_dict(obj["configuration"]) if obj.get("configuration") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


