# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.projects_v2_iteration_settings import ProjectsV2IterationSettings
from typing import Optional, Set
from typing_extensions import Self

class ProjectsV2FieldConfiguration(BaseModel):
    """
    Configuration for iteration fields.
    """ # noqa: E501
    start_day: Optional[StrictInt] = Field(default=None, description="The day of the week when the iteration starts.")
    duration: Optional[StrictInt] = Field(default=None, description="The duration of the iteration in days.")
    iterations: Optional[List[ProjectsV2IterationSettings]] = None
    __properties: ClassVar[List[str]] = ["start_day", "duration", "iterations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectsV2FieldConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in iterations (list)
        _items = []
        if self.iterations:
            for _item_iterations in self.iterations:
                if _item_iterations:
                    _items.append(_item_iterations.to_dict())
            _dict['iterations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectsV2FieldConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "start_day": obj.get("start_day"),
            "duration": obj.get("duration"),
            "iterations": [ProjectsV2IterationSettings.from_dict(_item) for _item in obj["iterations"]] if obj.get("iterations") is not None else None
        })
        return _obj


