# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from devopso.clients.github.models.issue import Issue
from devopso.clients.github.models.projects_v2_draft_issue import ProjectsV2DraftIssue
from devopso.clients.github.models.pull_request_simple import PullRequestSimple
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

PROJECTSV2ITEMSIMPLECONTENT_ONE_OF_SCHEMAS = ["Issue", "ProjectsV2DraftIssue", "PullRequestSimple"]

class ProjectsV2ItemSimpleContent(BaseModel):
    """
    The content represented by the item.
    """
    # data type: Issue
    oneof_schema_1_validator: Optional[Issue] = None
    # data type: PullRequestSimple
    oneof_schema_2_validator: Optional[PullRequestSimple] = None
    # data type: ProjectsV2DraftIssue
    oneof_schema_3_validator: Optional[ProjectsV2DraftIssue] = None
    actual_instance: Optional[Union[Issue, ProjectsV2DraftIssue, PullRequestSimple]] = None
    one_of_schemas: Set[str] = { "Issue", "ProjectsV2DraftIssue", "PullRequestSimple" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ProjectsV2ItemSimpleContent.model_construct()
        error_messages = []
        match = 0
        # validate data type: Issue
        if not isinstance(v, Issue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Issue`")
        else:
            match += 1
        # validate data type: PullRequestSimple
        if not isinstance(v, PullRequestSimple):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PullRequestSimple`")
        else:
            match += 1
        # validate data type: ProjectsV2DraftIssue
        if not isinstance(v, ProjectsV2DraftIssue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProjectsV2DraftIssue`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ProjectsV2ItemSimpleContent with oneOf schemas: Issue, ProjectsV2DraftIssue, PullRequestSimple. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ProjectsV2ItemSimpleContent with oneOf schemas: Issue, ProjectsV2DraftIssue, PullRequestSimple. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Issue
        try:
            instance.actual_instance = Issue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PullRequestSimple
        try:
            instance.actual_instance = PullRequestSimple.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProjectsV2DraftIssue
        try:
            instance.actual_instance = ProjectsV2DraftIssue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ProjectsV2ItemSimpleContent with oneOf schemas: Issue, ProjectsV2DraftIssue, PullRequestSimple. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ProjectsV2ItemSimpleContent with oneOf schemas: Issue, ProjectsV2DraftIssue, PullRequestSimple. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Issue, ProjectsV2DraftIssue, PullRequestSimple]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


