# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.projects_v2_item_content_type import ProjectsV2ItemContentType
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class ProjectsV2ItemWithContent(BaseModel):
    """
    An item belonging to a project
    """ # noqa: E501
    id: Union[StrictFloat, StrictInt] = Field(description="The unique identifier of the project item.")
    node_id: Optional[StrictStr] = Field(default=None, description="The node ID of the project item.")
    project_url: Optional[StrictStr] = Field(default=None, description="The API URL of the project that contains this item.")
    content_type: ProjectsV2ItemContentType
    content: Optional[Dict[str, Any]] = Field(default=None, description="The content of the item, which varies by content type.")
    creator: Optional[SimpleUser] = None
    created_at: datetime = Field(description="The time when the item was created.")
    updated_at: datetime = Field(description="The time when the item was last updated.")
    archived_at: Optional[datetime] = Field(description="The time when the item was archived.")
    item_url: Optional[StrictStr] = Field(default=None, description="The API URL of this item.")
    fields: Optional[List[Dict[str, Any]]] = Field(default=None, description="The fields and values associated with this item.")
    __properties: ClassVar[List[str]] = ["id", "node_id", "project_url", "content_type", "content", "creator", "created_at", "updated_at", "archived_at", "item_url", "fields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectsV2ItemWithContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict['creator'] = self.creator.to_dict()
        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if archived_at (nullable) is None
        # and model_fields_set contains the field
        if self.archived_at is None and "archived_at" in self.model_fields_set:
            _dict['archived_at'] = None

        # set to None if item_url (nullable) is None
        # and model_fields_set contains the field
        if self.item_url is None and "item_url" in self.model_fields_set:
            _dict['item_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectsV2ItemWithContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "project_url": obj.get("project_url"),
            "content_type": obj.get("content_type"),
            "content": obj.get("content"),
            "creator": SimpleUser.from_dict(obj["creator"]) if obj.get("creator") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "archived_at": obj.get("archived_at"),
            "item_url": obj.get("item_url"),
            "fields": obj.get("fields")
        })
        return _obj


