# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.projects_v2_single_select_options_description import ProjectsV2SingleSelectOptionsDescription
from devopso.clients.github.models.projects_v2_single_select_options_name import ProjectsV2SingleSelectOptionsName
from typing import Optional, Set
from typing_extensions import Self

class ProjectsV2SingleSelectOptions(BaseModel):
    """
    An option for a single select field
    """ # noqa: E501
    id: StrictStr = Field(description="The unique identifier of the option.")
    name: ProjectsV2SingleSelectOptionsName
    description: ProjectsV2SingleSelectOptionsDescription
    color: StrictStr = Field(description="The color associated with the option.")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "color"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectsV2SingleSelectOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectsV2SingleSelectOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": ProjectsV2SingleSelectOptionsName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "description": ProjectsV2SingleSelectOptionsDescription.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "color": obj.get("color")
        })
        return _obj


