# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.branch_protection_required_signatures import BranchProtectionRequiredSignatures
from devopso.clients.github.models.branch_restriction_policy import BranchRestrictionPolicy
from devopso.clients.github.models.protected_branch_allow_fork_syncing import ProtectedBranchAllowForkSyncing
from devopso.clients.github.models.protected_branch_enforce_admins import ProtectedBranchEnforceAdmins
from devopso.clients.github.models.protected_branch_lock_branch import ProtectedBranchLockBranch
from devopso.clients.github.models.protected_branch_required_conversation_resolution import ProtectedBranchRequiredConversationResolution
from devopso.clients.github.models.protected_branch_required_linear_history import ProtectedBranchRequiredLinearHistory
from devopso.clients.github.models.protected_branch_required_pull_request_reviews import ProtectedBranchRequiredPullRequestReviews
from devopso.clients.github.models.status_check_policy import StatusCheckPolicy
from typing import Optional, Set
from typing_extensions import Self

class ProtectedBranch(BaseModel):
    """
    Branch protections protect branches
    """ # noqa: E501
    url: StrictStr
    required_status_checks: Optional[StatusCheckPolicy] = None
    required_pull_request_reviews: Optional[ProtectedBranchRequiredPullRequestReviews] = None
    required_signatures: Optional[BranchProtectionRequiredSignatures] = None
    enforce_admins: Optional[ProtectedBranchEnforceAdmins] = None
    required_linear_history: Optional[ProtectedBranchRequiredLinearHistory] = None
    allow_force_pushes: Optional[ProtectedBranchRequiredLinearHistory] = None
    allow_deletions: Optional[ProtectedBranchRequiredLinearHistory] = None
    restrictions: Optional[BranchRestrictionPolicy] = None
    required_conversation_resolution: Optional[ProtectedBranchRequiredConversationResolution] = None
    block_creations: Optional[ProtectedBranchRequiredLinearHistory] = None
    lock_branch: Optional[ProtectedBranchLockBranch] = None
    allow_fork_syncing: Optional[ProtectedBranchAllowForkSyncing] = None
    __properties: ClassVar[List[str]] = ["url", "required_status_checks", "required_pull_request_reviews", "required_signatures", "enforce_admins", "required_linear_history", "allow_force_pushes", "allow_deletions", "restrictions", "required_conversation_resolution", "block_creations", "lock_branch", "allow_fork_syncing"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProtectedBranch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of required_status_checks
        if self.required_status_checks:
            _dict['required_status_checks'] = self.required_status_checks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_pull_request_reviews
        if self.required_pull_request_reviews:
            _dict['required_pull_request_reviews'] = self.required_pull_request_reviews.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_signatures
        if self.required_signatures:
            _dict['required_signatures'] = self.required_signatures.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enforce_admins
        if self.enforce_admins:
            _dict['enforce_admins'] = self.enforce_admins.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_linear_history
        if self.required_linear_history:
            _dict['required_linear_history'] = self.required_linear_history.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allow_force_pushes
        if self.allow_force_pushes:
            _dict['allow_force_pushes'] = self.allow_force_pushes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allow_deletions
        if self.allow_deletions:
            _dict['allow_deletions'] = self.allow_deletions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restrictions
        if self.restrictions:
            _dict['restrictions'] = self.restrictions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_conversation_resolution
        if self.required_conversation_resolution:
            _dict['required_conversation_resolution'] = self.required_conversation_resolution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of block_creations
        if self.block_creations:
            _dict['block_creations'] = self.block_creations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lock_branch
        if self.lock_branch:
            _dict['lock_branch'] = self.lock_branch.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allow_fork_syncing
        if self.allow_fork_syncing:
            _dict['allow_fork_syncing'] = self.allow_fork_syncing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProtectedBranch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "required_status_checks": StatusCheckPolicy.from_dict(obj["required_status_checks"]) if obj.get("required_status_checks") is not None else None,
            "required_pull_request_reviews": ProtectedBranchRequiredPullRequestReviews.from_dict(obj["required_pull_request_reviews"]) if obj.get("required_pull_request_reviews") is not None else None,
            "required_signatures": BranchProtectionRequiredSignatures.from_dict(obj["required_signatures"]) if obj.get("required_signatures") is not None else None,
            "enforce_admins": ProtectedBranchEnforceAdmins.from_dict(obj["enforce_admins"]) if obj.get("enforce_admins") is not None else None,
            "required_linear_history": ProtectedBranchRequiredLinearHistory.from_dict(obj["required_linear_history"]) if obj.get("required_linear_history") is not None else None,
            "allow_force_pushes": ProtectedBranchRequiredLinearHistory.from_dict(obj["allow_force_pushes"]) if obj.get("allow_force_pushes") is not None else None,
            "allow_deletions": ProtectedBranchRequiredLinearHistory.from_dict(obj["allow_deletions"]) if obj.get("allow_deletions") is not None else None,
            "restrictions": BranchRestrictionPolicy.from_dict(obj["restrictions"]) if obj.get("restrictions") is not None else None,
            "required_conversation_resolution": ProtectedBranchRequiredConversationResolution.from_dict(obj["required_conversation_resolution"]) if obj.get("required_conversation_resolution") is not None else None,
            "block_creations": ProtectedBranchRequiredLinearHistory.from_dict(obj["block_creations"]) if obj.get("block_creations") is not None else None,
            "lock_branch": ProtectedBranchLockBranch.from_dict(obj["lock_branch"]) if obj.get("lock_branch") is not None else None,
            "allow_fork_syncing": ProtectedBranchAllowForkSyncing.from_dict(obj["allow_fork_syncing"]) if obj.get("allow_fork_syncing") is not None else None
        })
        return _obj


