# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.user2 import User2
from typing import Optional, Set
from typing_extensions import Self

class PullRequestAutoMerge1(BaseModel):
    """
    The status of auto merging a pull request.
    """ # noqa: E501
    commit_message: Optional[StrictStr] = Field(description="Commit message for the merge commit.")
    commit_title: StrictStr = Field(description="Title for the merge commit message.")
    enabled_by: Optional[User2]
    merge_method: StrictStr = Field(description="The merge method to use.")
    __properties: ClassVar[List[str]] = ["commit_message", "commit_title", "enabled_by", "merge_method"]

    @field_validator('merge_method')
    def merge_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['merge', 'squash', 'rebase']):
            raise ValueError("must be one of enum values ('merge', 'squash', 'rebase')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullRequestAutoMerge1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enabled_by
        if self.enabled_by:
            _dict['enabled_by'] = self.enabled_by.to_dict()
        # set to None if commit_message (nullable) is None
        # and model_fields_set contains the field
        if self.commit_message is None and "commit_message" in self.model_fields_set:
            _dict['commit_message'] = None

        # set to None if enabled_by (nullable) is None
        # and model_fields_set contains the field
        if self.enabled_by is None and "enabled_by" in self.model_fields_set:
            _dict['enabled_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullRequestAutoMerge1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "commit_message": obj.get("commit_message"),
            "commit_title": obj.get("commit_title"),
            "enabled_by": User2.from_dict(obj["enabled_by"]) if obj.get("enabled_by") is not None else None,
            "merge_method": obj.get("merge_method")
        })
        return _obj


