# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.author_association import AuthorAssociation
from devopso.clients.github.models.auto_merge import AutoMerge
from devopso.clients.github.models.nullable_milestone import NullableMilestone
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.pull_request_simple_head import PullRequestSimpleHead
from devopso.clients.github.models.pull_request_simple_labels_inner import PullRequestSimpleLabelsInner
from devopso.clients.github.models.pull_request_simple_links import PullRequestSimpleLinks
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class PullRequestSimple(BaseModel):
    """
    Pull Request Simple
    """ # noqa: E501
    url: StrictStr
    id: StrictInt
    node_id: StrictStr
    html_url: StrictStr
    diff_url: StrictStr
    patch_url: StrictStr
    issue_url: StrictStr
    commits_url: StrictStr
    review_comments_url: StrictStr
    review_comment_url: StrictStr
    comments_url: StrictStr
    statuses_url: StrictStr
    number: StrictInt
    state: StrictStr
    locked: StrictBool
    title: StrictStr
    user: Optional[NullableSimpleUser]
    body: Optional[StrictStr]
    labels: List[PullRequestSimpleLabelsInner]
    milestone: Optional[NullableMilestone]
    active_lock_reason: Optional[StrictStr] = None
    created_at: datetime
    updated_at: datetime
    closed_at: Optional[datetime]
    merged_at: Optional[datetime]
    merge_commit_sha: Optional[StrictStr]
    assignee: Optional[NullableSimpleUser]
    assignees: Optional[List[SimpleUser]] = None
    requested_reviewers: Optional[List[SimpleUser]] = None
    requested_teams: Optional[List[Team]] = None
    head: PullRequestSimpleHead
    base: PullRequestSimpleHead
    links: PullRequestSimpleLinks = Field(alias="_links")
    author_association: AuthorAssociation
    auto_merge: Optional[AutoMerge]
    draft: Optional[StrictBool] = Field(default=None, description="Indicates whether or not the pull request is a draft.")
    __properties: ClassVar[List[str]] = ["url", "id", "node_id", "html_url", "diff_url", "patch_url", "issue_url", "commits_url", "review_comments_url", "review_comment_url", "comments_url", "statuses_url", "number", "state", "locked", "title", "user", "body", "labels", "milestone", "active_lock_reason", "created_at", "updated_at", "closed_at", "merged_at", "merge_commit_sha", "assignee", "assignees", "requested_reviewers", "requested_teams", "head", "base", "_links", "author_association", "auto_merge", "draft"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullRequestSimple from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assignee
        if self.assignee:
            _dict['assignee'] = self.assignee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in assignees (list)
        _items = []
        if self.assignees:
            for _item_assignees in self.assignees:
                if _item_assignees:
                    _items.append(_item_assignees.to_dict())
            _dict['assignees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in requested_reviewers (list)
        _items = []
        if self.requested_reviewers:
            for _item_requested_reviewers in self.requested_reviewers:
                if _item_requested_reviewers:
                    _items.append(_item_requested_reviewers.to_dict())
            _dict['requested_reviewers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in requested_teams (list)
        _items = []
        if self.requested_teams:
            for _item_requested_teams in self.requested_teams:
                if _item_requested_teams:
                    _items.append(_item_requested_teams.to_dict())
            _dict['requested_teams'] = _items
        # override the default output from pydantic by calling `to_dict()` of head
        if self.head:
            _dict['head'] = self.head.to_dict()
        # override the default output from pydantic by calling `to_dict()` of base
        if self.base:
            _dict['base'] = self.base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_merge
        if self.auto_merge:
            _dict['auto_merge'] = self.auto_merge.to_dict()
        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if milestone (nullable) is None
        # and model_fields_set contains the field
        if self.milestone is None and "milestone" in self.model_fields_set:
            _dict['milestone'] = None

        # set to None if active_lock_reason (nullable) is None
        # and model_fields_set contains the field
        if self.active_lock_reason is None and "active_lock_reason" in self.model_fields_set:
            _dict['active_lock_reason'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if merged_at (nullable) is None
        # and model_fields_set contains the field
        if self.merged_at is None and "merged_at" in self.model_fields_set:
            _dict['merged_at'] = None

        # set to None if merge_commit_sha (nullable) is None
        # and model_fields_set contains the field
        if self.merge_commit_sha is None and "merge_commit_sha" in self.model_fields_set:
            _dict['merge_commit_sha'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if assignees (nullable) is None
        # and model_fields_set contains the field
        if self.assignees is None and "assignees" in self.model_fields_set:
            _dict['assignees'] = None

        # set to None if requested_reviewers (nullable) is None
        # and model_fields_set contains the field
        if self.requested_reviewers is None and "requested_reviewers" in self.model_fields_set:
            _dict['requested_reviewers'] = None

        # set to None if requested_teams (nullable) is None
        # and model_fields_set contains the field
        if self.requested_teams is None and "requested_teams" in self.model_fields_set:
            _dict['requested_teams'] = None

        # set to None if auto_merge (nullable) is None
        # and model_fields_set contains the field
        if self.auto_merge is None and "auto_merge" in self.model_fields_set:
            _dict['auto_merge'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullRequestSimple from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "html_url": obj.get("html_url"),
            "diff_url": obj.get("diff_url"),
            "patch_url": obj.get("patch_url"),
            "issue_url": obj.get("issue_url"),
            "commits_url": obj.get("commits_url"),
            "review_comments_url": obj.get("review_comments_url"),
            "review_comment_url": obj.get("review_comment_url"),
            "comments_url": obj.get("comments_url"),
            "statuses_url": obj.get("statuses_url"),
            "number": obj.get("number"),
            "state": obj.get("state"),
            "locked": obj.get("locked"),
            "title": obj.get("title"),
            "user": NullableSimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "body": obj.get("body"),
            "labels": [PullRequestSimpleLabelsInner.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "milestone": NullableMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "active_lock_reason": obj.get("active_lock_reason"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "closed_at": obj.get("closed_at"),
            "merged_at": obj.get("merged_at"),
            "merge_commit_sha": obj.get("merge_commit_sha"),
            "assignee": NullableSimpleUser.from_dict(obj["assignee"]) if obj.get("assignee") is not None else None,
            "assignees": [SimpleUser.from_dict(_item) for _item in obj["assignees"]] if obj.get("assignees") is not None else None,
            "requested_reviewers": [SimpleUser.from_dict(_item) for _item in obj["requested_reviewers"]] if obj.get("requested_reviewers") is not None else None,
            "requested_teams": [Team.from_dict(_item) for _item in obj["requested_teams"]] if obj.get("requested_teams") is not None else None,
            "head": PullRequestSimpleHead.from_dict(obj["head"]) if obj.get("head") is not None else None,
            "base": PullRequestSimpleHead.from_dict(obj["base"]) if obj.get("base") is not None else None,
            "_links": PullRequestSimpleLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None,
            "author_association": obj.get("author_association"),
            "auto_merge": AutoMerge.from_dict(obj["auto_merge"]) if obj.get("auto_merge") is not None else None,
            "draft": obj.get("draft")
        })
        return _obj


