# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.link import Link
from typing import Optional, Set
from typing_extensions import Self

class PullRequestSimpleLinks(BaseModel):
    """
    PullRequestSimpleLinks
    """ # noqa: E501
    comments: Link
    commits: Link
    statuses: Link
    html: Link
    issue: Link
    review_comments: Link
    review_comment: Link
    var_self: Link = Field(alias="self")
    __properties: ClassVar[List[str]] = ["comments", "commits", "statuses", "html", "issue", "review_comments", "review_comment", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullRequestSimpleLinks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of comments
        if self.comments:
            _dict['comments'] = self.comments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of commits
        if self.commits:
            _dict['commits'] = self.commits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statuses
        if self.statuses:
            _dict['statuses'] = self.statuses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of html
        if self.html:
            _dict['html'] = self.html.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue
        if self.issue:
            _dict['issue'] = self.issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of review_comments
        if self.review_comments:
            _dict['review_comments'] = self.review_comments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of review_comment
        if self.review_comment:
            _dict['review_comment'] = self.review_comment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_self
        if self.var_self:
            _dict['self'] = self.var_self.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullRequestSimpleLinks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "comments": Link.from_dict(obj["comments"]) if obj.get("comments") is not None else None,
            "commits": Link.from_dict(obj["commits"]) if obj.get("commits") is not None else None,
            "statuses": Link.from_dict(obj["statuses"]) if obj.get("statuses") is not None else None,
            "html": Link.from_dict(obj["html"]) if obj.get("html") is not None else None,
            "issue": Link.from_dict(obj["issue"]) if obj.get("issue") is not None else None,
            "review_comments": Link.from_dict(obj["review_comments"]) if obj.get("review_comments") is not None else None,
            "review_comment": Link.from_dict(obj["review_comment"]) if obj.get("review_comment") is not None else None,
            "self": Link.from_dict(obj["self"]) if obj.get("self") is not None else None
        })
        return _obj


