# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.author_association import AuthorAssociation
from devopso.clients.github.models.auto_merge import AutoMerge
from devopso.clients.github.models.nullable_milestone import NullableMilestone
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.pull_request_head import PullRequestHead
from devopso.clients.github.models.pull_request_labels_inner import PullRequestLabelsInner
from devopso.clients.github.models.pull_request_simple_links import PullRequestSimpleLinks
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.team_simple import TeamSimple
from typing import Optional, Set
from typing_extensions import Self

class PullRequestWebhook(BaseModel):
    """
    PullRequestWebhook
    """ # noqa: E501
    url: StrictStr
    id: StrictInt
    node_id: StrictStr
    html_url: StrictStr
    diff_url: StrictStr
    patch_url: StrictStr
    issue_url: StrictStr
    commits_url: StrictStr
    review_comments_url: StrictStr
    review_comment_url: StrictStr
    comments_url: StrictStr
    statuses_url: StrictStr
    number: StrictInt = Field(description="Number uniquely identifying the pull request within its repository.")
    state: StrictStr = Field(description="State of this Pull Request. Either `open` or `closed`.")
    locked: StrictBool
    title: StrictStr = Field(description="The title of the pull request.")
    user: SimpleUser
    body: Optional[StrictStr]
    labels: List[PullRequestLabelsInner]
    milestone: Optional[NullableMilestone]
    active_lock_reason: Optional[StrictStr] = None
    created_at: datetime
    updated_at: datetime
    closed_at: Optional[datetime]
    merged_at: Optional[datetime]
    merge_commit_sha: Optional[StrictStr]
    assignee: Optional[NullableSimpleUser]
    assignees: Optional[List[SimpleUser]] = None
    requested_reviewers: Optional[List[SimpleUser]] = None
    requested_teams: Optional[List[TeamSimple]] = None
    head: PullRequestHead
    base: PullRequestHead
    links: PullRequestSimpleLinks = Field(alias="_links")
    author_association: AuthorAssociation
    auto_merge: Optional[AutoMerge]
    draft: Optional[StrictBool] = Field(default=None, description="Indicates whether or not the pull request is a draft.")
    merged: StrictBool
    mergeable: Optional[StrictBool]
    rebaseable: Optional[StrictBool] = None
    mergeable_state: StrictStr
    merged_by: Optional[NullableSimpleUser]
    comments: StrictInt
    review_comments: StrictInt
    maintainer_can_modify: StrictBool = Field(description="Indicates whether maintainers can modify the pull request.")
    commits: StrictInt
    additions: StrictInt
    deletions: StrictInt
    changed_files: StrictInt
    allow_auto_merge: Optional[StrictBool] = Field(default=False, description="Whether to allow auto-merge for pull requests.")
    allow_update_branch: Optional[StrictBool] = Field(default=None, description="Whether to allow updating the pull request's branch.")
    delete_branch_on_merge: Optional[StrictBool] = Field(default=False, description="Whether to delete head branches when pull requests are merged.")
    merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a merge commit message. - `PR_TITLE` - default to the pull request's title. - `PR_BODY` - default to the pull request's body. - `BLANK` - default to a blank commit message.")
    merge_commit_title: Optional[StrictStr] = Field(default=None, description="The default value for a merge commit title. - `PR_TITLE` - default to the pull request's title. - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., \"Merge pull request #123 from branch-name\").")
    squash_merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a squash merge commit message: - `PR_BODY` - default to the pull request's body. - `COMMIT_MESSAGES` - default to the branch's commit messages. - `BLANK` - default to a blank commit message.")
    squash_merge_commit_title: Optional[StrictStr] = Field(default=None, description="The default value for a squash merge commit title: - `PR_TITLE` - default to the pull request's title. - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).")
    use_squash_pr_title_as_default: Optional[StrictBool] = Field(default=False, description="Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.**")
    __properties: ClassVar[List[str]] = ["url", "id", "node_id", "html_url", "diff_url", "patch_url", "issue_url", "commits_url", "review_comments_url", "review_comment_url", "comments_url", "statuses_url", "number", "state", "locked", "title", "user", "body", "labels", "milestone", "active_lock_reason", "created_at", "updated_at", "closed_at", "merged_at", "merge_commit_sha", "assignee", "assignees", "requested_reviewers", "requested_teams", "head", "base", "_links", "author_association", "auto_merge", "draft", "merged", "mergeable", "rebaseable", "mergeable_state", "merged_by", "comments", "review_comments", "maintainer_can_modify", "commits", "additions", "deletions", "changed_files", "allow_auto_merge", "allow_update_branch", "delete_branch_on_merge", "merge_commit_message", "merge_commit_title", "squash_merge_commit_message", "squash_merge_commit_title", "use_squash_pr_title_as_default"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'closed']):
            raise ValueError("must be one of enum values ('open', 'closed')")
        return value

    @field_validator('merge_commit_message')
    def merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'PR_TITLE', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'PR_TITLE', 'BLANK')")
        return value

    @field_validator('merge_commit_title')
    def merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'MERGE_MESSAGE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'MERGE_MESSAGE')")
        return value

    @field_validator('squash_merge_commit_message')
    def squash_merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'COMMIT_MESSAGES', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'COMMIT_MESSAGES', 'BLANK')")
        return value

    @field_validator('squash_merge_commit_title')
    def squash_merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'COMMIT_OR_PR_TITLE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'COMMIT_OR_PR_TITLE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullRequestWebhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assignee
        if self.assignee:
            _dict['assignee'] = self.assignee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in assignees (list)
        _items = []
        if self.assignees:
            for _item_assignees in self.assignees:
                if _item_assignees:
                    _items.append(_item_assignees.to_dict())
            _dict['assignees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in requested_reviewers (list)
        _items = []
        if self.requested_reviewers:
            for _item_requested_reviewers in self.requested_reviewers:
                if _item_requested_reviewers:
                    _items.append(_item_requested_reviewers.to_dict())
            _dict['requested_reviewers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in requested_teams (list)
        _items = []
        if self.requested_teams:
            for _item_requested_teams in self.requested_teams:
                if _item_requested_teams:
                    _items.append(_item_requested_teams.to_dict())
            _dict['requested_teams'] = _items
        # override the default output from pydantic by calling `to_dict()` of head
        if self.head:
            _dict['head'] = self.head.to_dict()
        # override the default output from pydantic by calling `to_dict()` of base
        if self.base:
            _dict['base'] = self.base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_merge
        if self.auto_merge:
            _dict['auto_merge'] = self.auto_merge.to_dict()
        # override the default output from pydantic by calling `to_dict()` of merged_by
        if self.merged_by:
            _dict['merged_by'] = self.merged_by.to_dict()
        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if milestone (nullable) is None
        # and model_fields_set contains the field
        if self.milestone is None and "milestone" in self.model_fields_set:
            _dict['milestone'] = None

        # set to None if active_lock_reason (nullable) is None
        # and model_fields_set contains the field
        if self.active_lock_reason is None and "active_lock_reason" in self.model_fields_set:
            _dict['active_lock_reason'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if merged_at (nullable) is None
        # and model_fields_set contains the field
        if self.merged_at is None and "merged_at" in self.model_fields_set:
            _dict['merged_at'] = None

        # set to None if merge_commit_sha (nullable) is None
        # and model_fields_set contains the field
        if self.merge_commit_sha is None and "merge_commit_sha" in self.model_fields_set:
            _dict['merge_commit_sha'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if assignees (nullable) is None
        # and model_fields_set contains the field
        if self.assignees is None and "assignees" in self.model_fields_set:
            _dict['assignees'] = None

        # set to None if requested_reviewers (nullable) is None
        # and model_fields_set contains the field
        if self.requested_reviewers is None and "requested_reviewers" in self.model_fields_set:
            _dict['requested_reviewers'] = None

        # set to None if requested_teams (nullable) is None
        # and model_fields_set contains the field
        if self.requested_teams is None and "requested_teams" in self.model_fields_set:
            _dict['requested_teams'] = None

        # set to None if auto_merge (nullable) is None
        # and model_fields_set contains the field
        if self.auto_merge is None and "auto_merge" in self.model_fields_set:
            _dict['auto_merge'] = None

        # set to None if mergeable (nullable) is None
        # and model_fields_set contains the field
        if self.mergeable is None and "mergeable" in self.model_fields_set:
            _dict['mergeable'] = None

        # set to None if rebaseable (nullable) is None
        # and model_fields_set contains the field
        if self.rebaseable is None and "rebaseable" in self.model_fields_set:
            _dict['rebaseable'] = None

        # set to None if merged_by (nullable) is None
        # and model_fields_set contains the field
        if self.merged_by is None and "merged_by" in self.model_fields_set:
            _dict['merged_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullRequestWebhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "html_url": obj.get("html_url"),
            "diff_url": obj.get("diff_url"),
            "patch_url": obj.get("patch_url"),
            "issue_url": obj.get("issue_url"),
            "commits_url": obj.get("commits_url"),
            "review_comments_url": obj.get("review_comments_url"),
            "review_comment_url": obj.get("review_comment_url"),
            "comments_url": obj.get("comments_url"),
            "statuses_url": obj.get("statuses_url"),
            "number": obj.get("number"),
            "state": obj.get("state"),
            "locked": obj.get("locked"),
            "title": obj.get("title"),
            "user": SimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "body": obj.get("body"),
            "labels": [PullRequestLabelsInner.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "milestone": NullableMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "active_lock_reason": obj.get("active_lock_reason"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "closed_at": obj.get("closed_at"),
            "merged_at": obj.get("merged_at"),
            "merge_commit_sha": obj.get("merge_commit_sha"),
            "assignee": NullableSimpleUser.from_dict(obj["assignee"]) if obj.get("assignee") is not None else None,
            "assignees": [SimpleUser.from_dict(_item) for _item in obj["assignees"]] if obj.get("assignees") is not None else None,
            "requested_reviewers": [SimpleUser.from_dict(_item) for _item in obj["requested_reviewers"]] if obj.get("requested_reviewers") is not None else None,
            "requested_teams": [TeamSimple.from_dict(_item) for _item in obj["requested_teams"]] if obj.get("requested_teams") is not None else None,
            "head": PullRequestHead.from_dict(obj["head"]) if obj.get("head") is not None else None,
            "base": PullRequestHead.from_dict(obj["base"]) if obj.get("base") is not None else None,
            "_links": PullRequestSimpleLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None,
            "author_association": obj.get("author_association"),
            "auto_merge": AutoMerge.from_dict(obj["auto_merge"]) if obj.get("auto_merge") is not None else None,
            "draft": obj.get("draft"),
            "merged": obj.get("merged"),
            "mergeable": obj.get("mergeable"),
            "rebaseable": obj.get("rebaseable"),
            "mergeable_state": obj.get("mergeable_state"),
            "merged_by": NullableSimpleUser.from_dict(obj["merged_by"]) if obj.get("merged_by") is not None else None,
            "comments": obj.get("comments"),
            "review_comments": obj.get("review_comments"),
            "maintainer_can_modify": obj.get("maintainer_can_modify"),
            "commits": obj.get("commits"),
            "additions": obj.get("additions"),
            "deletions": obj.get("deletions"),
            "changed_files": obj.get("changed_files"),
            "allow_auto_merge": obj.get("allow_auto_merge") if obj.get("allow_auto_merge") is not None else False,
            "allow_update_branch": obj.get("allow_update_branch"),
            "delete_branch_on_merge": obj.get("delete_branch_on_merge") if obj.get("delete_branch_on_merge") is not None else False,
            "merge_commit_message": obj.get("merge_commit_message"),
            "merge_commit_title": obj.get("merge_commit_title"),
            "squash_merge_commit_message": obj.get("squash_merge_commit_message"),
            "squash_merge_commit_title": obj.get("squash_merge_commit_title"),
            "use_squash_pr_title_as_default": obj.get("use_squash_pr_title_as_default") if obj.get("use_squash_pr_title_as_default") is not None else False
        })
        return _obj


