# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PullsCreateReviewCommentRequest(BaseModel):
    """
    PullsCreateReviewCommentRequest
    """ # noqa: E501
    body: StrictStr = Field(description="The text of the review comment.")
    commit_id: StrictStr = Field(description="The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.")
    path: StrictStr = Field(description="The relative path to the file that necessitates a comment.")
    position: Optional[StrictInt] = Field(default=None, description="**This parameter is closing down. Use `line` instead**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. The position value equals the number of lines down from the first \"@@\" hunk header in the file you want to add a comment. The line just below the \"@@\" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.")
    side: Optional[StrictStr] = Field(default=None, description="In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see \"[Diff view options](https://docs.github.com/articles/about-comparing-branches-in-pull-requests#diff-view-options)\" in the GitHub Help documentation.")
    line: Optional[StrictInt] = Field(default=None, description="**Required unless using `subject_type:file`**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.")
    start_line: Optional[StrictInt] = Field(default=None, description="**Required when using multi-line comments unless using `in_reply_to`**. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see \"[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation.")
    start_side: Optional[StrictStr] = Field(default=None, description="**Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see \"[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation. See `side` in this table for additional context.")
    in_reply_to: Optional[StrictInt] = Field(default=None, description="The ID of the review comment to reply to. To find the ID of a review comment with [\"List review comments on a pull request\"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.")
    subject_type: Optional[StrictStr] = Field(default=None, description="The level at which the comment is targeted.")
    __properties: ClassVar[List[str]] = ["body", "commit_id", "path", "position", "side", "line", "start_line", "start_side", "in_reply_to", "subject_type"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LEFT', 'RIGHT']):
            raise ValueError("must be one of enum values ('LEFT', 'RIGHT')")
        return value

    @field_validator('start_side')
    def start_side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LEFT', 'RIGHT', 'side']):
            raise ValueError("must be one of enum values ('LEFT', 'RIGHT', 'side')")
        return value

    @field_validator('subject_type')
    def subject_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['line', 'file']):
            raise ValueError("must be one of enum values ('line', 'file')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullsCreateReviewCommentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullsCreateReviewCommentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body": obj.get("body"),
            "commit_id": obj.get("commit_id"),
            "path": obj.get("path"),
            "position": obj.get("position"),
            "side": obj.get("side"),
            "line": obj.get("line"),
            "start_line": obj.get("start_line"),
            "start_side": obj.get("start_side"),
            "in_reply_to": obj.get("in_reply_to"),
            "subject_type": obj.get("subject_type")
        })
        return _obj


