# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class ReleaseAsset1(BaseModel):
    """
    Data related to a release.
    """ # noqa: E501
    browser_download_url: StrictStr
    content_type: StrictStr
    created_at: datetime
    download_count: StrictInt
    id: StrictInt
    label: Optional[StrictStr]
    name: StrictStr = Field(description="The file name of the asset.")
    node_id: StrictStr
    size: StrictInt
    digest: Optional[StrictStr]
    state: StrictStr = Field(description="State of the release asset.")
    updated_at: datetime
    uploader: Optional[User] = None
    url: StrictStr
    __properties: ClassVar[List[str]] = ["browser_download_url", "content_type", "created_at", "download_count", "id", "label", "name", "node_id", "size", "digest", "state", "updated_at", "uploader", "url"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['uploaded']):
            raise ValueError("must be one of enum values ('uploaded')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReleaseAsset1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of uploader
        if self.uploader:
            _dict['uploader'] = self.uploader.to_dict()
        # set to None if label (nullable) is None
        # and model_fields_set contains the field
        if self.label is None and "label" in self.model_fields_set:
            _dict['label'] = None

        # set to None if digest (nullable) is None
        # and model_fields_set contains the field
        if self.digest is None and "digest" in self.model_fields_set:
            _dict['digest'] = None

        # set to None if uploader (nullable) is None
        # and model_fields_set contains the field
        if self.uploader is None and "uploader" in self.model_fields_set:
            _dict['uploader'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReleaseAsset1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "browser_download_url": obj.get("browser_download_url"),
            "content_type": obj.get("content_type"),
            "created_at": obj.get("created_at"),
            "download_count": obj.get("download_count"),
            "id": obj.get("id"),
            "label": obj.get("label"),
            "name": obj.get("name"),
            "node_id": obj.get("node_id"),
            "size": obj.get("size"),
            "digest": obj.get("digest"),
            "state": obj.get("state"),
            "updated_at": obj.get("updated_at"),
            "uploader": User.from_dict(obj["uploader"]) if obj.get("uploader") is not None else None,
            "url": obj.get("url")
        })
        return _obj


