# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.full_repository_permissions import FullRepositoryPermissions
from devopso.clients.github.models.nullable_license_simple import NullableLicenseSimple
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.search_result_text_matches_inner import SearchResultTextMatchesInner
from typing import Optional, Set
from typing_extensions import Self

class RepoSearchResultItem(BaseModel):
    """
    Repo Search Result Item
    """ # noqa: E501
    id: StrictInt
    node_id: StrictStr
    name: StrictStr
    full_name: StrictStr
    owner: Optional[NullableSimpleUser]
    private: StrictBool
    html_url: StrictStr
    description: Optional[StrictStr]
    fork: StrictBool
    url: StrictStr
    created_at: datetime
    updated_at: datetime
    pushed_at: datetime
    homepage: Optional[StrictStr]
    size: StrictInt
    stargazers_count: StrictInt
    watchers_count: StrictInt
    language: Optional[StrictStr]
    forks_count: StrictInt
    open_issues_count: StrictInt
    master_branch: Optional[StrictStr] = None
    default_branch: StrictStr
    score: Union[StrictFloat, StrictInt]
    forks_url: StrictStr
    keys_url: StrictStr
    collaborators_url: StrictStr
    teams_url: StrictStr
    hooks_url: StrictStr
    issue_events_url: StrictStr
    events_url: StrictStr
    assignees_url: StrictStr
    branches_url: StrictStr
    tags_url: StrictStr
    blobs_url: StrictStr
    git_tags_url: StrictStr
    git_refs_url: StrictStr
    trees_url: StrictStr
    statuses_url: StrictStr
    languages_url: StrictStr
    stargazers_url: StrictStr
    contributors_url: StrictStr
    subscribers_url: StrictStr
    subscription_url: StrictStr
    commits_url: StrictStr
    git_commits_url: StrictStr
    comments_url: StrictStr
    issue_comment_url: StrictStr
    contents_url: StrictStr
    compare_url: StrictStr
    merges_url: StrictStr
    archive_url: StrictStr
    downloads_url: StrictStr
    issues_url: StrictStr
    pulls_url: StrictStr
    milestones_url: StrictStr
    notifications_url: StrictStr
    labels_url: StrictStr
    releases_url: StrictStr
    deployments_url: StrictStr
    git_url: StrictStr
    ssh_url: StrictStr
    clone_url: StrictStr
    svn_url: StrictStr
    forks: StrictInt
    open_issues: StrictInt
    watchers: StrictInt
    topics: Optional[List[StrictStr]] = None
    mirror_url: Optional[StrictStr]
    has_issues: StrictBool
    has_projects: StrictBool
    has_pages: StrictBool
    has_wiki: StrictBool
    has_downloads: StrictBool
    has_discussions: Optional[StrictBool] = None
    archived: StrictBool
    disabled: StrictBool = Field(description="Returns whether or not this repository disabled.")
    visibility: Optional[StrictStr] = Field(default=None, description="The repository visibility: public, private, or internal.")
    license: Optional[NullableLicenseSimple]
    permissions: Optional[FullRepositoryPermissions] = None
    text_matches: Optional[List[SearchResultTextMatchesInner]] = None
    temp_clone_token: Optional[StrictStr] = None
    allow_merge_commit: Optional[StrictBool] = None
    allow_squash_merge: Optional[StrictBool] = None
    allow_rebase_merge: Optional[StrictBool] = None
    allow_auto_merge: Optional[StrictBool] = None
    delete_branch_on_merge: Optional[StrictBool] = None
    allow_forking: Optional[StrictBool] = None
    is_template: Optional[StrictBool] = None
    web_commit_signoff_required: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "node_id", "name", "full_name", "owner", "private", "html_url", "description", "fork", "url", "created_at", "updated_at", "pushed_at", "homepage", "size", "stargazers_count", "watchers_count", "language", "forks_count", "open_issues_count", "master_branch", "default_branch", "score", "forks_url", "keys_url", "collaborators_url", "teams_url", "hooks_url", "issue_events_url", "events_url", "assignees_url", "branches_url", "tags_url", "blobs_url", "git_tags_url", "git_refs_url", "trees_url", "statuses_url", "languages_url", "stargazers_url", "contributors_url", "subscribers_url", "subscription_url", "commits_url", "git_commits_url", "comments_url", "issue_comment_url", "contents_url", "compare_url", "merges_url", "archive_url", "downloads_url", "issues_url", "pulls_url", "milestones_url", "notifications_url", "labels_url", "releases_url", "deployments_url", "git_url", "ssh_url", "clone_url", "svn_url", "forks", "open_issues", "watchers", "topics", "mirror_url", "has_issues", "has_projects", "has_pages", "has_wiki", "has_downloads", "has_discussions", "archived", "disabled", "visibility", "license", "permissions", "text_matches", "temp_clone_token", "allow_merge_commit", "allow_squash_merge", "allow_rebase_merge", "allow_auto_merge", "delete_branch_on_merge", "allow_forking", "is_template", "web_commit_signoff_required"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepoSearchResultItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of license
        if self.license:
            _dict['license'] = self.license.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in text_matches (list)
        _items = []
        if self.text_matches:
            for _item_text_matches in self.text_matches:
                if _item_text_matches:
                    _items.append(_item_text_matches.to_dict())
            _dict['text_matches'] = _items
        # set to None if owner (nullable) is None
        # and model_fields_set contains the field
        if self.owner is None and "owner" in self.model_fields_set:
            _dict['owner'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if homepage (nullable) is None
        # and model_fields_set contains the field
        if self.homepage is None and "homepage" in self.model_fields_set:
            _dict['homepage'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if mirror_url (nullable) is None
        # and model_fields_set contains the field
        if self.mirror_url is None and "mirror_url" in self.model_fields_set:
            _dict['mirror_url'] = None

        # set to None if license (nullable) is None
        # and model_fields_set contains the field
        if self.license is None and "license" in self.model_fields_set:
            _dict['license'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepoSearchResultItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "name": obj.get("name"),
            "full_name": obj.get("full_name"),
            "owner": NullableSimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "private": obj.get("private"),
            "html_url": obj.get("html_url"),
            "description": obj.get("description"),
            "fork": obj.get("fork"),
            "url": obj.get("url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "pushed_at": obj.get("pushed_at"),
            "homepage": obj.get("homepage"),
            "size": obj.get("size"),
            "stargazers_count": obj.get("stargazers_count"),
            "watchers_count": obj.get("watchers_count"),
            "language": obj.get("language"),
            "forks_count": obj.get("forks_count"),
            "open_issues_count": obj.get("open_issues_count"),
            "master_branch": obj.get("master_branch"),
            "default_branch": obj.get("default_branch"),
            "score": obj.get("score"),
            "forks_url": obj.get("forks_url"),
            "keys_url": obj.get("keys_url"),
            "collaborators_url": obj.get("collaborators_url"),
            "teams_url": obj.get("teams_url"),
            "hooks_url": obj.get("hooks_url"),
            "issue_events_url": obj.get("issue_events_url"),
            "events_url": obj.get("events_url"),
            "assignees_url": obj.get("assignees_url"),
            "branches_url": obj.get("branches_url"),
            "tags_url": obj.get("tags_url"),
            "blobs_url": obj.get("blobs_url"),
            "git_tags_url": obj.get("git_tags_url"),
            "git_refs_url": obj.get("git_refs_url"),
            "trees_url": obj.get("trees_url"),
            "statuses_url": obj.get("statuses_url"),
            "languages_url": obj.get("languages_url"),
            "stargazers_url": obj.get("stargazers_url"),
            "contributors_url": obj.get("contributors_url"),
            "subscribers_url": obj.get("subscribers_url"),
            "subscription_url": obj.get("subscription_url"),
            "commits_url": obj.get("commits_url"),
            "git_commits_url": obj.get("git_commits_url"),
            "comments_url": obj.get("comments_url"),
            "issue_comment_url": obj.get("issue_comment_url"),
            "contents_url": obj.get("contents_url"),
            "compare_url": obj.get("compare_url"),
            "merges_url": obj.get("merges_url"),
            "archive_url": obj.get("archive_url"),
            "downloads_url": obj.get("downloads_url"),
            "issues_url": obj.get("issues_url"),
            "pulls_url": obj.get("pulls_url"),
            "milestones_url": obj.get("milestones_url"),
            "notifications_url": obj.get("notifications_url"),
            "labels_url": obj.get("labels_url"),
            "releases_url": obj.get("releases_url"),
            "deployments_url": obj.get("deployments_url"),
            "git_url": obj.get("git_url"),
            "ssh_url": obj.get("ssh_url"),
            "clone_url": obj.get("clone_url"),
            "svn_url": obj.get("svn_url"),
            "forks": obj.get("forks"),
            "open_issues": obj.get("open_issues"),
            "watchers": obj.get("watchers"),
            "topics": obj.get("topics"),
            "mirror_url": obj.get("mirror_url"),
            "has_issues": obj.get("has_issues"),
            "has_projects": obj.get("has_projects"),
            "has_pages": obj.get("has_pages"),
            "has_wiki": obj.get("has_wiki"),
            "has_downloads": obj.get("has_downloads"),
            "has_discussions": obj.get("has_discussions"),
            "archived": obj.get("archived"),
            "disabled": obj.get("disabled"),
            "visibility": obj.get("visibility"),
            "license": NullableLicenseSimple.from_dict(obj["license"]) if obj.get("license") is not None else None,
            "permissions": FullRepositoryPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "text_matches": [SearchResultTextMatchesInner.from_dict(_item) for _item in obj["text_matches"]] if obj.get("text_matches") is not None else None,
            "temp_clone_token": obj.get("temp_clone_token"),
            "allow_merge_commit": obj.get("allow_merge_commit"),
            "allow_squash_merge": obj.get("allow_squash_merge"),
            "allow_rebase_merge": obj.get("allow_rebase_merge"),
            "allow_auto_merge": obj.get("allow_auto_merge"),
            "delete_branch_on_merge": obj.get("delete_branch_on_merge"),
            "allow_forking": obj.get("allow_forking"),
            "is_template": obj.get("is_template"),
            "web_commit_signoff_required": obj.get("web_commit_signoff_required")
        })
        return _obj


