# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repos_create_deployment_request_payload import ReposCreateDeploymentRequestPayload
from typing import Optional, Set
from typing_extensions import Self

class ReposCreateDeploymentRequest(BaseModel):
    """
    ReposCreateDeploymentRequest
    """ # noqa: E501
    ref: StrictStr = Field(description="The ref to deploy. This can be a branch, tag, or SHA.")
    task: Optional[StrictStr] = Field(default='deploy', description="Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).")
    auto_merge: Optional[StrictBool] = Field(default=True, description="Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.")
    required_contexts: Optional[List[StrictStr]] = Field(default=None, description="The [status](https://docs.github.com/rest/commits/statuses) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.")
    payload: Optional[ReposCreateDeploymentRequestPayload] = None
    environment: Optional[StrictStr] = Field(default='production', description="Name for the target deployment environment (e.g., `production`, `staging`, `qa`).")
    description: Optional[StrictStr] = Field(default='', description="Short description of the deployment.")
    transient_environment: Optional[StrictBool] = Field(default=False, description="Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`")
    production_environment: Optional[StrictBool] = Field(default=None, description="Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.")
    __properties: ClassVar[List[str]] = ["ref", "task", "auto_merge", "required_contexts", "payload", "environment", "description", "transient_environment", "production_environment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreateDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreateDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ref": obj.get("ref"),
            "task": obj.get("task") if obj.get("task") is not None else 'deploy',
            "auto_merge": obj.get("auto_merge") if obj.get("auto_merge") is not None else True,
            "required_contexts": obj.get("required_contexts"),
            "payload": ReposCreateDeploymentRequestPayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "environment": obj.get("environment") if obj.get("environment") is not None else 'production',
            "description": obj.get("description") if obj.get("description") is not None else '',
            "transient_environment": obj.get("transient_environment") if obj.get("transient_environment") is not None else False,
            "production_environment": obj.get("production_environment")
        })
        return _obj


