# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReposCreateDeploymentStatusRequest(BaseModel):
    """
    ReposCreateDeploymentStatusRequest
    """ # noqa: E501
    state: StrictStr = Field(description="The state of the status. When you set a transient deployment to `inactive`, the deployment will be shown as `destroyed` in GitHub.")
    target_url: Optional[StrictStr] = Field(default='', description="The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment.  > [!NOTE] > It's recommended to use the `log_url` parameter, which replaces `target_url`.")
    log_url: Optional[StrictStr] = Field(default='', description="The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `\"\"`")
    description: Optional[StrictStr] = Field(default='', description="A short description of the status. The maximum description length is 140 characters.")
    environment: Optional[StrictStr] = Field(default=None, description="Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. If not defined, the environment of the previous status on the deployment will be used, if it exists. Otherwise, the environment of the deployment will be used.")
    environment_url: Optional[StrictStr] = Field(default='', description="Sets the URL for accessing your environment. Default: `\"\"`")
    auto_inactive: Optional[StrictBool] = Field(default=None, description="Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`")
    __properties: ClassVar[List[str]] = ["state", "target_url", "log_url", "description", "environment", "environment_url", "auto_inactive"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['error', 'failure', 'inactive', 'in_progress', 'queued', 'pending', 'success']):
            raise ValueError("must be one of enum values ('error', 'failure', 'inactive', 'in_progress', 'queued', 'pending', 'success')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreateDeploymentStatusRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreateDeploymentStatusRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "target_url": obj.get("target_url") if obj.get("target_url") is not None else '',
            "log_url": obj.get("log_url") if obj.get("log_url") is not None else '',
            "description": obj.get("description") if obj.get("description") is not None else '',
            "environment": obj.get("environment"),
            "environment_url": obj.get("environment_url") if obj.get("environment_url") is not None else '',
            "auto_inactive": obj.get("auto_inactive")
        })
        return _obj


