# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ReposCreatePagesDeploymentRequest(BaseModel):
    """
    The object used to create GitHub Pages deployment
    """ # noqa: E501
    artifact_id: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The ID of an artifact that contains the .zip or .tar of static assets to deploy. The artifact belongs to the repository. Either `artifact_id` or `artifact_url` are required.")
    artifact_url: Optional[StrictStr] = Field(default=None, description="The URL of an artifact that contains the .zip or .tar of static assets to deploy. The artifact belongs to the repository. Either `artifact_id` or `artifact_url` are required.")
    environment: Optional[StrictStr] = Field(default='github-pages', description="The target environment for this GitHub Pages deployment.")
    pages_build_version: StrictStr = Field(description="A unique string that represents the version of the build for this deployment.")
    oidc_token: StrictStr = Field(description="The OIDC token issued by GitHub Actions certifying the origin of the deployment.")
    __properties: ClassVar[List[str]] = ["artifact_id", "artifact_url", "environment", "pages_build_version", "oidc_token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreatePagesDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreatePagesDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifact_id": obj.get("artifact_id"),
            "artifact_url": obj.get("artifact_url"),
            "environment": obj.get("environment") if obj.get("environment") is not None else 'github-pages',
            "pages_build_version": obj.get("pages_build_version") if obj.get("pages_build_version") is not None else 'GITHUB_SHA',
            "oidc_token": obj.get("oidc_token")
        })
        return _obj


