# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReposCreateReleaseRequest(BaseModel):
    """
    ReposCreateReleaseRequest
    """ # noqa: E501
    tag_name: StrictStr = Field(description="The name of the tag.")
    target_commitish: Optional[StrictStr] = Field(default=None, description="Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the release.")
    body: Optional[StrictStr] = Field(default=None, description="Text describing the contents of the tag.")
    draft: Optional[StrictBool] = Field(default=False, description="`true` to create a draft (unpublished) release, `false` to create a published one.")
    prerelease: Optional[StrictBool] = Field(default=False, description="`true` to identify the release as a prerelease. `false` to identify the release as a full release.")
    discussion_category_name: Optional[StrictStr] = Field(default=None, description="If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see \"[Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).\"")
    generate_release_notes: Optional[StrictBool] = Field(default=False, description="Whether to automatically generate the name and body for this release. If `name` is specified, the specified name will be used; otherwise, a name will be automatically generated. If `body` is specified, the body will be pre-pended to the automatically generated notes.")
    make_latest: Optional[StrictStr] = Field(default='true', description="Specifies whether this release should be set as the latest release for the repository. Drafts and prereleases cannot be set as latest. Defaults to `true` for newly published releases. `legacy` specifies that the latest release should be determined based on the release creation date and higher semantic version.")
    __properties: ClassVar[List[str]] = ["tag_name", "target_commitish", "name", "body", "draft", "prerelease", "discussion_category_name", "generate_release_notes", "make_latest"]

    @field_validator('make_latest')
    def make_latest_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false', 'legacy']):
            raise ValueError("must be one of enum values ('true', 'false', 'legacy')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreateReleaseRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreateReleaseRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tag_name": obj.get("tag_name"),
            "target_commitish": obj.get("target_commitish"),
            "name": obj.get("name"),
            "body": obj.get("body"),
            "draft": obj.get("draft") if obj.get("draft") is not None else False,
            "prerelease": obj.get("prerelease") if obj.get("prerelease") is not None else False,
            "discussion_category_name": obj.get("discussion_category_name"),
            "generate_release_notes": obj.get("generate_release_notes") if obj.get("generate_release_notes") is not None else False,
            "make_latest": obj.get("make_latest") if obj.get("make_latest") is not None else 'true'
        })
        return _obj


