# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repository_rule import RepositoryRule
from devopso.clients.github.models.repository_rule_enforcement import RepositoryRuleEnforcement
from devopso.clients.github.models.repository_ruleset_bypass_actor import RepositoryRulesetBypassActor
from devopso.clients.github.models.repository_ruleset_conditions import RepositoryRulesetConditions
from typing import Optional, Set
from typing_extensions import Self

class ReposCreateRepoRulesetRequest(BaseModel):
    """
    ReposCreateRepoRulesetRequest
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the ruleset.")
    target: Optional[StrictStr] = Field(default='branch', description="The target of the ruleset")
    enforcement: RepositoryRuleEnforcement
    bypass_actors: Optional[List[RepositoryRulesetBypassActor]] = Field(default=None, description="The actors that can bypass the rules in this ruleset")
    conditions: Optional[RepositoryRulesetConditions] = None
    rules: Optional[List[RepositoryRule]] = Field(default=None, description="An array of rules within the ruleset.")
    __properties: ClassVar[List[str]] = ["name", "target", "enforcement", "bypass_actors", "conditions", "rules"]

    @field_validator('target')
    def target_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['branch', 'tag', 'push']):
            raise ValueError("must be one of enum values ('branch', 'tag', 'push')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreateRepoRulesetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bypass_actors (list)
        _items = []
        if self.bypass_actors:
            for _item_bypass_actors in self.bypass_actors:
                if _item_bypass_actors:
                    _items.append(_item_bypass_actors.to_dict())
            _dict['bypass_actors'] = _items
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['rules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreateRepoRulesetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "target": obj.get("target") if obj.get("target") is not None else 'branch',
            "enforcement": obj.get("enforcement"),
            "bypass_actors": [RepositoryRulesetBypassActor.from_dict(_item) for _item in obj["bypass_actors"]] if obj.get("bypass_actors") is not None else None,
            "conditions": RepositoryRulesetConditions.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "rules": [RepositoryRule.from_dict(_item) for _item in obj["rules"]] if obj.get("rules") is not None else None
        })
        return _obj


