# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReposCreateUsingTemplateRequest(BaseModel):
    """
    ReposCreateUsingTemplateRequest
    """ # noqa: E501
    owner: Optional[StrictStr] = Field(default=None, description="The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.")
    name: StrictStr = Field(description="The name of the new repository.")
    description: Optional[StrictStr] = Field(default=None, description="A short description of the new repository.")
    include_all_branches: Optional[StrictBool] = Field(default=False, description="Set to `true` to include the directory structure and files from all branches in the template repository, and not just the default branch. Default: `false`.")
    private: Optional[StrictBool] = Field(default=False, description="Either `true` to create a new private repository or `false` to create a new public one.")
    __properties: ClassVar[List[str]] = ["owner", "name", "description", "include_all_branches", "private"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposCreateUsingTemplateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposCreateUsingTemplateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "owner": obj.get("owner"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "include_all_branches": obj.get("include_all_branches") if obj.get("include_all_branches") is not None else False,
            "private": obj.get("private") if obj.get("private") is not None else False
        })
        return _obj


