# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repos_update_branch_protection_request_required_pull_request_reviews import ReposUpdateBranchProtectionRequestRequiredPullRequestReviews
from devopso.clients.github.models.repos_update_branch_protection_request_required_status_checks import ReposUpdateBranchProtectionRequestRequiredStatusChecks
from devopso.clients.github.models.repos_update_branch_protection_request_restrictions import ReposUpdateBranchProtectionRequestRestrictions
from typing import Optional, Set
from typing_extensions import Self

class ReposUpdateBranchProtectionRequest(BaseModel):
    """
    ReposUpdateBranchProtectionRequest
    """ # noqa: E501
    required_status_checks: Optional[ReposUpdateBranchProtectionRequestRequiredStatusChecks]
    enforce_admins: Optional[StrictBool] = Field(description="Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.")
    required_pull_request_reviews: Optional[ReposUpdateBranchProtectionRequestRequiredPullRequestReviews]
    restrictions: Optional[ReposUpdateBranchProtectionRequestRestrictions]
    required_linear_history: Optional[StrictBool] = Field(default=None, description="Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see \"[Requiring a linear commit history](https://docs.github.com/github/administering-a-repository/requiring-a-linear-commit-history)\" in the GitHub Help documentation.")
    allow_force_pushes: Optional[StrictBool] = Field(default=None, description="Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://docs.github.com/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.\"")
    allow_deletions: Optional[StrictBool] = Field(default=None, description="Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://docs.github.com/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.")
    block_creations: Optional[StrictBool] = Field(default=None, description="If set to `true`, the `restrictions` branch protection settings which limits who can push will also block pushes which create new branches, unless the push is initiated by a user, team, or app which has the ability to push. Set to `true` to restrict new branch creation. Default: `false`.")
    required_conversation_resolution: Optional[StrictBool] = Field(default=None, description="Requires all conversations on code to be resolved before a pull request can be merged into a branch that matches this rule. Set to `false` to disable. Default: `false`.")
    lock_branch: Optional[StrictBool] = Field(default=False, description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch. Default: `false`.")
    allow_fork_syncing: Optional[StrictBool] = Field(default=False, description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing. Default: `false`.")
    __properties: ClassVar[List[str]] = ["required_status_checks", "enforce_admins", "required_pull_request_reviews", "restrictions", "required_linear_history", "allow_force_pushes", "allow_deletions", "block_creations", "required_conversation_resolution", "lock_branch", "allow_fork_syncing"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposUpdateBranchProtectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of required_status_checks
        if self.required_status_checks:
            _dict['required_status_checks'] = self.required_status_checks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required_pull_request_reviews
        if self.required_pull_request_reviews:
            _dict['required_pull_request_reviews'] = self.required_pull_request_reviews.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restrictions
        if self.restrictions:
            _dict['restrictions'] = self.restrictions.to_dict()
        # set to None if required_status_checks (nullable) is None
        # and model_fields_set contains the field
        if self.required_status_checks is None and "required_status_checks" in self.model_fields_set:
            _dict['required_status_checks'] = None

        # set to None if enforce_admins (nullable) is None
        # and model_fields_set contains the field
        if self.enforce_admins is None and "enforce_admins" in self.model_fields_set:
            _dict['enforce_admins'] = None

        # set to None if required_pull_request_reviews (nullable) is None
        # and model_fields_set contains the field
        if self.required_pull_request_reviews is None and "required_pull_request_reviews" in self.model_fields_set:
            _dict['required_pull_request_reviews'] = None

        # set to None if restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.restrictions is None and "restrictions" in self.model_fields_set:
            _dict['restrictions'] = None

        # set to None if allow_force_pushes (nullable) is None
        # and model_fields_set contains the field
        if self.allow_force_pushes is None and "allow_force_pushes" in self.model_fields_set:
            _dict['allow_force_pushes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposUpdateBranchProtectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "required_status_checks": ReposUpdateBranchProtectionRequestRequiredStatusChecks.from_dict(obj["required_status_checks"]) if obj.get("required_status_checks") is not None else None,
            "enforce_admins": obj.get("enforce_admins"),
            "required_pull_request_reviews": ReposUpdateBranchProtectionRequestRequiredPullRequestReviews.from_dict(obj["required_pull_request_reviews"]) if obj.get("required_pull_request_reviews") is not None else None,
            "restrictions": ReposUpdateBranchProtectionRequestRestrictions.from_dict(obj["restrictions"]) if obj.get("restrictions") is not None else None,
            "required_linear_history": obj.get("required_linear_history"),
            "allow_force_pushes": obj.get("allow_force_pushes"),
            "allow_deletions": obj.get("allow_deletions"),
            "block_creations": obj.get("block_creations"),
            "required_conversation_resolution": obj.get("required_conversation_resolution"),
            "lock_branch": obj.get("lock_branch") if obj.get("lock_branch") is not None else False,
            "allow_fork_syncing": obj.get("allow_fork_syncing") if obj.get("allow_fork_syncing") is not None else False
        })
        return _obj


