# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repos_update_request_security_and_analysis import ReposUpdateRequestSecurityAndAnalysis
from typing import Optional, Set
from typing_extensions import Self

class ReposUpdateRequest(BaseModel):
    """
    ReposUpdateRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the repository.")
    description: Optional[StrictStr] = Field(default=None, description="A short description of the repository.")
    homepage: Optional[StrictStr] = Field(default=None, description="A URL with more information about the repository.")
    private: Optional[StrictBool] = Field(default=False, description="Either `true` to make the repository private or `false` to make it public. Default: `false`.   **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://docs.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.")
    visibility: Optional[StrictStr] = Field(default=None, description="The visibility of the repository.")
    security_and_analysis: Optional[ReposUpdateRequestSecurityAndAnalysis] = None
    has_issues: Optional[StrictBool] = Field(default=True, description="Either `true` to enable issues for this repository or `false` to disable them.")
    has_projects: Optional[StrictBool] = Field(default=True, description="Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.")
    has_wiki: Optional[StrictBool] = Field(default=True, description="Either `true` to enable the wiki for this repository or `false` to disable it.")
    is_template: Optional[StrictBool] = Field(default=False, description="Either `true` to make this repo available as a template repository or `false` to prevent it.")
    default_branch: Optional[StrictStr] = Field(default=None, description="Updates the default branch for this repository.")
    allow_squash_merge: Optional[StrictBool] = Field(default=True, description="Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.")
    allow_merge_commit: Optional[StrictBool] = Field(default=True, description="Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.")
    allow_rebase_merge: Optional[StrictBool] = Field(default=True, description="Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.")
    allow_auto_merge: Optional[StrictBool] = Field(default=False, description="Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.")
    delete_branch_on_merge: Optional[StrictBool] = Field(default=False, description="Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.")
    allow_update_branch: Optional[StrictBool] = Field(default=False, description="Either `true` to always allow a pull request head branch that is behind its base branch to be updated even if it is not required to be up to date before merging, or false otherwise.")
    use_squash_pr_title_as_default: Optional[StrictBool] = Field(default=False, description="Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property is closing down. Please use `squash_merge_commit_title` instead.")
    squash_merge_commit_title: Optional[StrictStr] = Field(default=None, description="Required when using `squash_merge_commit_message`.  The default value for a squash merge commit title:  - `PR_TITLE` - default to the pull request's title. - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).")
    squash_merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a squash merge commit message:  - `PR_BODY` - default to the pull request's body. - `COMMIT_MESSAGES` - default to the branch's commit messages. - `BLANK` - default to a blank commit message.")
    merge_commit_title: Optional[StrictStr] = Field(default=None, description="Required when using `merge_commit_message`.  The default value for a merge commit title.  - `PR_TITLE` - default to the pull request's title. - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).")
    merge_commit_message: Optional[StrictStr] = Field(default=None, description="The default value for a merge commit message.  - `PR_TITLE` - default to the pull request's title. - `PR_BODY` - default to the pull request's body. - `BLANK` - default to a blank commit message.")
    archived: Optional[StrictBool] = Field(default=False, description="Whether to archive this repository. `false` will unarchive a previously archived repository.")
    allow_forking: Optional[StrictBool] = Field(default=False, description="Either `true` to allow private forks, or `false` to prevent private forks.")
    web_commit_signoff_required: Optional[StrictBool] = Field(default=False, description="Either `true` to require contributors to sign off on web-based commits, or `false` to not require contributors to sign off on web-based commits.")
    __properties: ClassVar[List[str]] = ["name", "description", "homepage", "private", "visibility", "security_and_analysis", "has_issues", "has_projects", "has_wiki", "is_template", "default_branch", "allow_squash_merge", "allow_merge_commit", "allow_rebase_merge", "allow_auto_merge", "delete_branch_on_merge", "allow_update_branch", "use_squash_pr_title_as_default", "squash_merge_commit_title", "squash_merge_commit_message", "merge_commit_title", "merge_commit_message", "archived", "allow_forking", "web_commit_signoff_required"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    @field_validator('squash_merge_commit_title')
    def squash_merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'COMMIT_OR_PR_TITLE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'COMMIT_OR_PR_TITLE')")
        return value

    @field_validator('squash_merge_commit_message')
    def squash_merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'COMMIT_MESSAGES', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'COMMIT_MESSAGES', 'BLANK')")
        return value

    @field_validator('merge_commit_title')
    def merge_commit_title_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_TITLE', 'MERGE_MESSAGE']):
            raise ValueError("must be one of enum values ('PR_TITLE', 'MERGE_MESSAGE')")
        return value

    @field_validator('merge_commit_message')
    def merge_commit_message_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PR_BODY', 'PR_TITLE', 'BLANK']):
            raise ValueError("must be one of enum values ('PR_BODY', 'PR_TITLE', 'BLANK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security_and_analysis
        if self.security_and_analysis:
            _dict['security_and_analysis'] = self.security_and_analysis.to_dict()
        # set to None if security_and_analysis (nullable) is None
        # and model_fields_set contains the field
        if self.security_and_analysis is None and "security_and_analysis" in self.model_fields_set:
            _dict['security_and_analysis'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "homepage": obj.get("homepage"),
            "private": obj.get("private") if obj.get("private") is not None else False,
            "visibility": obj.get("visibility"),
            "security_and_analysis": ReposUpdateRequestSecurityAndAnalysis.from_dict(obj["security_and_analysis"]) if obj.get("security_and_analysis") is not None else None,
            "has_issues": obj.get("has_issues") if obj.get("has_issues") is not None else True,
            "has_projects": obj.get("has_projects") if obj.get("has_projects") is not None else True,
            "has_wiki": obj.get("has_wiki") if obj.get("has_wiki") is not None else True,
            "is_template": obj.get("is_template") if obj.get("is_template") is not None else False,
            "default_branch": obj.get("default_branch"),
            "allow_squash_merge": obj.get("allow_squash_merge") if obj.get("allow_squash_merge") is not None else True,
            "allow_merge_commit": obj.get("allow_merge_commit") if obj.get("allow_merge_commit") is not None else True,
            "allow_rebase_merge": obj.get("allow_rebase_merge") if obj.get("allow_rebase_merge") is not None else True,
            "allow_auto_merge": obj.get("allow_auto_merge") if obj.get("allow_auto_merge") is not None else False,
            "delete_branch_on_merge": obj.get("delete_branch_on_merge") if obj.get("delete_branch_on_merge") is not None else False,
            "allow_update_branch": obj.get("allow_update_branch") if obj.get("allow_update_branch") is not None else False,
            "use_squash_pr_title_as_default": obj.get("use_squash_pr_title_as_default") if obj.get("use_squash_pr_title_as_default") is not None else False,
            "squash_merge_commit_title": obj.get("squash_merge_commit_title"),
            "squash_merge_commit_message": obj.get("squash_merge_commit_message"),
            "merge_commit_title": obj.get("merge_commit_title"),
            "merge_commit_message": obj.get("merge_commit_message"),
            "archived": obj.get("archived") if obj.get("archived") is not None else False,
            "allow_forking": obj.get("allow_forking") if obj.get("allow_forking") is not None else False,
            "web_commit_signoff_required": obj.get("web_commit_signoff_required") if obj.get("web_commit_signoff_required") is not None else False
        })
        return _obj


