# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.webhook_config import WebhookConfig
from typing import Optional, Set
from typing_extensions import Self

class ReposUpdateWebhookRequest(BaseModel):
    """
    ReposUpdateWebhookRequest
    """ # noqa: E501
    config: Optional[WebhookConfig] = None
    events: Optional[List[StrictStr]] = Field(default=None, description="Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. This replaces the entire array of events.")
    add_events: Optional[List[StrictStr]] = Field(default=None, description="Determines a list of events to be added to the list of events that the Hook triggers for.")
    remove_events: Optional[List[StrictStr]] = Field(default=None, description="Determines a list of events to be removed from the list of events that the Hook triggers for.")
    active: Optional[StrictBool] = Field(default=True, description="Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.")
    __properties: ClassVar[List[str]] = ["config", "events", "add_events", "remove_events", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReposUpdateWebhookRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReposUpdateWebhookRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "config": WebhookConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "events": obj.get("events"),
            "add_events": obj.get("add_events"),
            "remove_events": obj.get("remove_events"),
            "active": obj.get("active") if obj.get("active") is not None else True
        })
        return _obj


