# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.cvss_severities import CvssSeverities
from devopso.clients.github.models.global_advisory_cvss import GlobalAdvisoryCvss
from devopso.clients.github.models.global_advisory_cwes_inner import GlobalAdvisoryCwesInner
from devopso.clients.github.models.global_advisory_identifiers_inner import GlobalAdvisoryIdentifiersInner
from devopso.clients.github.models.repository_advisory_credit import RepositoryAdvisoryCredit
from devopso.clients.github.models.repository_advisory_credits_inner import RepositoryAdvisoryCreditsInner
from devopso.clients.github.models.repository_advisory_submission import RepositoryAdvisorySubmission
from devopso.clients.github.models.repository_advisory_vulnerability import RepositoryAdvisoryVulnerability
from devopso.clients.github.models.simple_repository import SimpleRepository
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class RepositoryAdvisory(BaseModel):
    """
    A repository security advisory.
    """ # noqa: E501
    ghsa_id: StrictStr = Field(description="The GitHub Security Advisory ID.")
    cve_id: Optional[StrictStr] = Field(description="The Common Vulnerabilities and Exposures (CVE) ID.")
    url: StrictStr = Field(description="The API URL for the advisory.")
    html_url: StrictStr = Field(description="The URL for the advisory.")
    summary: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="A short summary of the advisory.")
    description: Optional[Annotated[str, Field(strict=True, max_length=65535)]] = Field(description="A detailed description of what the advisory entails.")
    severity: Optional[StrictStr] = Field(description="The severity of the advisory.")
    author: Optional[SimpleUser] = Field(description="The author of the advisory.")
    publisher: Optional[SimpleUser] = Field(description="The publisher of the advisory.")
    identifiers: List[GlobalAdvisoryIdentifiersInner]
    state: StrictStr = Field(description="The state of the advisory.")
    created_at: Optional[datetime] = Field(description="The date and time of when the advisory was created, in ISO 8601 format.")
    updated_at: Optional[datetime] = Field(description="The date and time of when the advisory was last updated, in ISO 8601 format.")
    published_at: Optional[datetime] = Field(description="The date and time of when the advisory was published, in ISO 8601 format.")
    closed_at: Optional[datetime] = Field(description="The date and time of when the advisory was closed, in ISO 8601 format.")
    withdrawn_at: Optional[datetime] = Field(description="The date and time of when the advisory was withdrawn, in ISO 8601 format.")
    submission: Optional[RepositoryAdvisorySubmission]
    vulnerabilities: Optional[List[RepositoryAdvisoryVulnerability]]
    cvss: Optional[GlobalAdvisoryCvss]
    cvss_severities: Optional[CvssSeverities] = None
    cwes: Optional[List[GlobalAdvisoryCwesInner]]
    cwe_ids: Optional[List[StrictStr]] = Field(description="A list of only the CWE IDs.")
    credits: Optional[List[RepositoryAdvisoryCreditsInner]]
    credits_detailed: Optional[List[RepositoryAdvisoryCredit]]
    collaborating_users: Optional[List[SimpleUser]] = Field(description="A list of users that collaborate on the advisory.")
    collaborating_teams: Optional[List[Team]] = Field(description="A list of teams that collaborate on the advisory.")
    private_fork: Optional[SimpleRepository] = Field(description="A temporary private fork of the advisory's repository for collaborating on a fix.")
    __properties: ClassVar[List[str]] = ["ghsa_id", "cve_id", "url", "html_url", "summary", "description", "severity", "author", "publisher", "identifiers", "state", "created_at", "updated_at", "published_at", "closed_at", "withdrawn_at", "submission", "vulnerabilities", "cvss", "cvss_severities", "cwes", "cwe_ids", "credits", "credits_detailed", "collaborating_users", "collaborating_teams", "private_fork"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['critical', 'high', 'medium', 'low']):
            raise ValueError("must be one of enum values ('critical', 'high', 'medium', 'low')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['published', 'closed', 'withdrawn', 'draft', 'triage']):
            raise ValueError("must be one of enum values ('published', 'closed', 'withdrawn', 'draft', 'triage')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "ghsa_id",
            "url",
            "html_url",
            "author",
            "publisher",
            "identifiers",
            "created_at",
            "updated_at",
            "published_at",
            "closed_at",
            "withdrawn_at",
            "cwes",
            "credits_detailed",
            "private_fork",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of publisher
        if self.publisher:
            _dict['publisher'] = self.publisher.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of submission
        if self.submission:
            _dict['submission'] = self.submission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # override the default output from pydantic by calling `to_dict()` of cvss
        if self.cvss:
            _dict['cvss'] = self.cvss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_severities
        if self.cvss_severities:
            _dict['cvss_severities'] = self.cvss_severities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cwes (list)
        _items = []
        if self.cwes:
            for _item_cwes in self.cwes:
                if _item_cwes:
                    _items.append(_item_cwes.to_dict())
            _dict['cwes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits_detailed (list)
        _items = []
        if self.credits_detailed:
            for _item_credits_detailed in self.credits_detailed:
                if _item_credits_detailed:
                    _items.append(_item_credits_detailed.to_dict())
            _dict['credits_detailed'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in collaborating_users (list)
        _items = []
        if self.collaborating_users:
            for _item_collaborating_users in self.collaborating_users:
                if _item_collaborating_users:
                    _items.append(_item_collaborating_users.to_dict())
            _dict['collaborating_users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in collaborating_teams (list)
        _items = []
        if self.collaborating_teams:
            for _item_collaborating_teams in self.collaborating_teams:
                if _item_collaborating_teams:
                    _items.append(_item_collaborating_teams.to_dict())
            _dict['collaborating_teams'] = _items
        # override the default output from pydantic by calling `to_dict()` of private_fork
        if self.private_fork:
            _dict['private_fork'] = self.private_fork.to_dict()
        # set to None if cve_id (nullable) is None
        # and model_fields_set contains the field
        if self.cve_id is None and "cve_id" in self.model_fields_set:
            _dict['cve_id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if severity (nullable) is None
        # and model_fields_set contains the field
        if self.severity is None and "severity" in self.model_fields_set:
            _dict['severity'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if publisher (nullable) is None
        # and model_fields_set contains the field
        if self.publisher is None and "publisher" in self.model_fields_set:
            _dict['publisher'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if published_at (nullable) is None
        # and model_fields_set contains the field
        if self.published_at is None and "published_at" in self.model_fields_set:
            _dict['published_at'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if withdrawn_at (nullable) is None
        # and model_fields_set contains the field
        if self.withdrawn_at is None and "withdrawn_at" in self.model_fields_set:
            _dict['withdrawn_at'] = None

        # set to None if submission (nullable) is None
        # and model_fields_set contains the field
        if self.submission is None and "submission" in self.model_fields_set:
            _dict['submission'] = None

        # set to None if vulnerabilities (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerabilities is None and "vulnerabilities" in self.model_fields_set:
            _dict['vulnerabilities'] = None

        # set to None if cvss (nullable) is None
        # and model_fields_set contains the field
        if self.cvss is None and "cvss" in self.model_fields_set:
            _dict['cvss'] = None

        # set to None if cvss_severities (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_severities is None and "cvss_severities" in self.model_fields_set:
            _dict['cvss_severities'] = None

        # set to None if cwes (nullable) is None
        # and model_fields_set contains the field
        if self.cwes is None and "cwes" in self.model_fields_set:
            _dict['cwes'] = None

        # set to None if cwe_ids (nullable) is None
        # and model_fields_set contains the field
        if self.cwe_ids is None and "cwe_ids" in self.model_fields_set:
            _dict['cwe_ids'] = None

        # set to None if credits (nullable) is None
        # and model_fields_set contains the field
        if self.credits is None and "credits" in self.model_fields_set:
            _dict['credits'] = None

        # set to None if credits_detailed (nullable) is None
        # and model_fields_set contains the field
        if self.credits_detailed is None and "credits_detailed" in self.model_fields_set:
            _dict['credits_detailed'] = None

        # set to None if collaborating_users (nullable) is None
        # and model_fields_set contains the field
        if self.collaborating_users is None and "collaborating_users" in self.model_fields_set:
            _dict['collaborating_users'] = None

        # set to None if collaborating_teams (nullable) is None
        # and model_fields_set contains the field
        if self.collaborating_teams is None and "collaborating_teams" in self.model_fields_set:
            _dict['collaborating_teams'] = None

        # set to None if private_fork (nullable) is None
        # and model_fields_set contains the field
        if self.private_fork is None and "private_fork" in self.model_fields_set:
            _dict['private_fork'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ghsa_id": obj.get("ghsa_id"),
            "cve_id": obj.get("cve_id"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "severity": obj.get("severity"),
            "author": SimpleUser.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "publisher": SimpleUser.from_dict(obj["publisher"]) if obj.get("publisher") is not None else None,
            "identifiers": [GlobalAdvisoryIdentifiersInner.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "state": obj.get("state"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "published_at": obj.get("published_at"),
            "closed_at": obj.get("closed_at"),
            "withdrawn_at": obj.get("withdrawn_at"),
            "submission": RepositoryAdvisorySubmission.from_dict(obj["submission"]) if obj.get("submission") is not None else None,
            "vulnerabilities": [RepositoryAdvisoryVulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "cvss": GlobalAdvisoryCvss.from_dict(obj["cvss"]) if obj.get("cvss") is not None else None,
            "cvss_severities": CvssSeverities.from_dict(obj["cvss_severities"]) if obj.get("cvss_severities") is not None else None,
            "cwes": [GlobalAdvisoryCwesInner.from_dict(_item) for _item in obj["cwes"]] if obj.get("cwes") is not None else None,
            "cwe_ids": obj.get("cwe_ids"),
            "credits": [RepositoryAdvisoryCreditsInner.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None,
            "credits_detailed": [RepositoryAdvisoryCredit.from_dict(_item) for _item in obj["credits_detailed"]] if obj.get("credits_detailed") is not None else None,
            "collaborating_users": [SimpleUser.from_dict(_item) for _item in obj["collaborating_users"]] if obj.get("collaborating_users") is not None else None,
            "collaborating_teams": [Team.from_dict(_item) for _item in obj["collaborating_teams"]] if obj.get("collaborating_teams") is not None else None,
            "private_fork": SimpleRepository.from_dict(obj["private_fork"]) if obj.get("private_fork") is not None else None
        })
        return _obj


