# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.repository_advisory_create_credits_inner import RepositoryAdvisoryCreateCreditsInner
from devopso.clients.github.models.repository_advisory_create_vulnerabilities_inner import RepositoryAdvisoryCreateVulnerabilitiesInner
from typing import Optional, Set
from typing_extensions import Self

class RepositoryAdvisoryUpdate(BaseModel):
    """
    RepositoryAdvisoryUpdate
    """ # noqa: E501
    summary: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="A short summary of the advisory.")
    description: Optional[Annotated[str, Field(strict=True, max_length=65535)]] = Field(default=None, description="A detailed description of what the advisory impacts.")
    cve_id: Optional[StrictStr] = Field(default=None, description="The Common Vulnerabilities and Exposures (CVE) ID.")
    vulnerabilities: Optional[List[RepositoryAdvisoryCreateVulnerabilitiesInner]] = Field(default=None, description="A product affected by the vulnerability detailed in a repository security advisory.")
    cwe_ids: Optional[List[StrictStr]] = Field(default=None, description="A list of Common Weakness Enumeration (CWE) IDs.")
    credits: Optional[List[RepositoryAdvisoryCreateCreditsInner]] = Field(default=None, description="A list of users receiving credit for their participation in the security advisory.")
    severity: Optional[StrictStr] = Field(default=None, description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.")
    cvss_vector_string: Optional[StrictStr] = Field(default=None, description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.")
    state: Optional[StrictStr] = Field(default=None, description="The state of the advisory.")
    collaborating_users: Optional[List[StrictStr]] = Field(default=None, description="A list of usernames who have been granted write access to the advisory.")
    collaborating_teams: Optional[List[StrictStr]] = Field(default=None, description="A list of team slugs which have been granted write access to the advisory.")
    __properties: ClassVar[List[str]] = ["summary", "description", "cve_id", "vulnerabilities", "cwe_ids", "credits", "severity", "cvss_vector_string", "state", "collaborating_users", "collaborating_teams"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['critical', 'high', 'medium', 'low']):
            raise ValueError("must be one of enum values ('critical', 'high', 'medium', 'low')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['published', 'closed', 'draft']):
            raise ValueError("must be one of enum values ('published', 'closed', 'draft')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryAdvisoryUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # set to None if cve_id (nullable) is None
        # and model_fields_set contains the field
        if self.cve_id is None and "cve_id" in self.model_fields_set:
            _dict['cve_id'] = None

        # set to None if cwe_ids (nullable) is None
        # and model_fields_set contains the field
        if self.cwe_ids is None and "cwe_ids" in self.model_fields_set:
            _dict['cwe_ids'] = None

        # set to None if credits (nullable) is None
        # and model_fields_set contains the field
        if self.credits is None and "credits" in self.model_fields_set:
            _dict['credits'] = None

        # set to None if severity (nullable) is None
        # and model_fields_set contains the field
        if self.severity is None and "severity" in self.model_fields_set:
            _dict['severity'] = None

        # set to None if cvss_vector_string (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_vector_string is None and "cvss_vector_string" in self.model_fields_set:
            _dict['cvss_vector_string'] = None

        # set to None if collaborating_users (nullable) is None
        # and model_fields_set contains the field
        if self.collaborating_users is None and "collaborating_users" in self.model_fields_set:
            _dict['collaborating_users'] = None

        # set to None if collaborating_teams (nullable) is None
        # and model_fields_set contains the field
        if self.collaborating_teams is None and "collaborating_teams" in self.model_fields_set:
            _dict['collaborating_teams'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryAdvisoryUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "cve_id": obj.get("cve_id"),
            "vulnerabilities": [RepositoryAdvisoryCreateVulnerabilitiesInner.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "cwe_ids": obj.get("cwe_ids"),
            "credits": [RepositoryAdvisoryCreateCreditsInner.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None,
            "severity": obj.get("severity"),
            "cvss_vector_string": obj.get("cvss_vector_string"),
            "state": obj.get("state"),
            "collaborating_users": obj.get("collaborating_users"),
            "collaborating_teams": obj.get("collaborating_teams")
        })
        return _obj


