# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.vulnerability_package import VulnerabilityPackage
from typing import Optional, Set
from typing_extensions import Self

class RepositoryAdvisoryVulnerability(BaseModel):
    """
    A product affected by the vulnerability detailed in a repository security advisory.
    """ # noqa: E501
    package: Optional[VulnerabilityPackage]
    vulnerable_version_range: Optional[StrictStr] = Field(description="The range of the package versions affected by the vulnerability.")
    patched_versions: Optional[StrictStr] = Field(description="The package version(s) that resolve the vulnerability.")
    vulnerable_functions: Optional[List[StrictStr]] = Field(description="The functions in the package that are affected.")
    __properties: ClassVar[List[str]] = ["package", "vulnerable_version_range", "patched_versions", "vulnerable_functions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryAdvisoryVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of package
        if self.package:
            _dict['package'] = self.package.to_dict()
        # set to None if package (nullable) is None
        # and model_fields_set contains the field
        if self.package is None and "package" in self.model_fields_set:
            _dict['package'] = None

        # set to None if vulnerable_version_range (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerable_version_range is None and "vulnerable_version_range" in self.model_fields_set:
            _dict['vulnerable_version_range'] = None

        # set to None if patched_versions (nullable) is None
        # and model_fields_set contains the field
        if self.patched_versions is None and "patched_versions" in self.model_fields_set:
            _dict['patched_versions'] = None

        # set to None if vulnerable_functions (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerable_functions is None and "vulnerable_functions" in self.model_fields_set:
            _dict['vulnerable_functions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryAdvisoryVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "package": VulnerabilityPackage.from_dict(obj["package"]) if obj.get("package") is not None else None,
            "vulnerable_version_range": obj.get("vulnerable_version_range"),
            "patched_versions": obj.get("patched_versions"),
            "vulnerable_functions": obj.get("vulnerable_functions")
        })
        return _obj


