# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.minimal_repository import MinimalRepository
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from typing import Optional, Set
from typing_extensions import Self

class RepositoryInvitation(BaseModel):
    """
    Repository invitations let you manage who you collaborate with.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the repository invitation.")
    repository: MinimalRepository
    invitee: Optional[NullableSimpleUser]
    inviter: Optional[NullableSimpleUser]
    permissions: StrictStr = Field(description="The permission associated with the invitation.")
    created_at: datetime
    expired: Optional[StrictBool] = Field(default=None, description="Whether or not the invitation has expired")
    url: StrictStr = Field(description="URL for the repository invitation")
    html_url: StrictStr
    node_id: StrictStr
    __properties: ClassVar[List[str]] = ["id", "repository", "invitee", "inviter", "permissions", "created_at", "expired", "url", "html_url", "node_id"]

    @field_validator('permissions')
    def permissions_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['read', 'write', 'admin', 'triage', 'maintain']):
            raise ValueError("must be one of enum values ('read', 'write', 'admin', 'triage', 'maintain')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryInvitation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invitee
        if self.invitee:
            _dict['invitee'] = self.invitee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inviter
        if self.inviter:
            _dict['inviter'] = self.inviter.to_dict()
        # set to None if invitee (nullable) is None
        # and model_fields_set contains the field
        if self.invitee is None and "invitee" in self.model_fields_set:
            _dict['invitee'] = None

        # set to None if inviter (nullable) is None
        # and model_fields_set contains the field
        if self.inviter is None and "inviter" in self.model_fields_set:
            _dict['inviter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryInvitation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "repository": MinimalRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "invitee": NullableSimpleUser.from_dict(obj["invitee"]) if obj.get("invitee") is not None else None,
            "inviter": NullableSimpleUser.from_dict(obj["inviter"]) if obj.get("inviter") is not None else None,
            "permissions": obj.get("permissions"),
            "created_at": obj.get("created_at"),
            "expired": obj.get("expired"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "node_id": obj.get("node_id")
        })
        return _obj


