# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from devopso.clients.github.models.repository_rule_branch_name_pattern import RepositoryRuleBranchNamePattern
from devopso.clients.github.models.repository_rule_code_scanning import RepositoryRuleCodeScanning
from devopso.clients.github.models.repository_rule_commit_author_email_pattern import RepositoryRuleCommitAuthorEmailPattern
from devopso.clients.github.models.repository_rule_commit_message_pattern import RepositoryRuleCommitMessagePattern
from devopso.clients.github.models.repository_rule_committer_email_pattern import RepositoryRuleCommitterEmailPattern
from devopso.clients.github.models.repository_rule_copilot_code_review import RepositoryRuleCopilotCodeReview
from devopso.clients.github.models.repository_rule_creation import RepositoryRuleCreation
from devopso.clients.github.models.repository_rule_deletion import RepositoryRuleDeletion
from devopso.clients.github.models.repository_rule_file_extension_restriction import RepositoryRuleFileExtensionRestriction
from devopso.clients.github.models.repository_rule_file_path_restriction import RepositoryRuleFilePathRestriction
from devopso.clients.github.models.repository_rule_max_file_path_length import RepositoryRuleMaxFilePathLength
from devopso.clients.github.models.repository_rule_max_file_size import RepositoryRuleMaxFileSize
from devopso.clients.github.models.repository_rule_merge_queue import RepositoryRuleMergeQueue
from devopso.clients.github.models.repository_rule_non_fast_forward import RepositoryRuleNonFastForward
from devopso.clients.github.models.repository_rule_pull_request import RepositoryRulePullRequest
from devopso.clients.github.models.repository_rule_required_deployments import RepositoryRuleRequiredDeployments
from devopso.clients.github.models.repository_rule_required_linear_history import RepositoryRuleRequiredLinearHistory
from devopso.clients.github.models.repository_rule_required_signatures import RepositoryRuleRequiredSignatures
from devopso.clients.github.models.repository_rule_required_status_checks import RepositoryRuleRequiredStatusChecks
from devopso.clients.github.models.repository_rule_tag_name_pattern import RepositoryRuleTagNamePattern
from devopso.clients.github.models.repository_rule_update import RepositoryRuleUpdate
from devopso.clients.github.models.repository_rule_workflows import RepositoryRuleWorkflows
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

REPOSITORYRULE_ONE_OF_SCHEMAS = ["RepositoryRuleBranchNamePattern", "RepositoryRuleCodeScanning", "RepositoryRuleCommitAuthorEmailPattern", "RepositoryRuleCommitMessagePattern", "RepositoryRuleCommitterEmailPattern", "RepositoryRuleCopilotCodeReview", "RepositoryRuleCreation", "RepositoryRuleDeletion", "RepositoryRuleFileExtensionRestriction", "RepositoryRuleFilePathRestriction", "RepositoryRuleMaxFilePathLength", "RepositoryRuleMaxFileSize", "RepositoryRuleMergeQueue", "RepositoryRuleNonFastForward", "RepositoryRulePullRequest", "RepositoryRuleRequiredDeployments", "RepositoryRuleRequiredLinearHistory", "RepositoryRuleRequiredSignatures", "RepositoryRuleRequiredStatusChecks", "RepositoryRuleTagNamePattern", "RepositoryRuleUpdate", "RepositoryRuleWorkflows"]

class RepositoryRule(BaseModel):
    """
    A repository rule.
    """
    # data type: RepositoryRuleCreation
    oneof_schema_1_validator: Optional[RepositoryRuleCreation] = None
    # data type: RepositoryRuleUpdate
    oneof_schema_2_validator: Optional[RepositoryRuleUpdate] = None
    # data type: RepositoryRuleDeletion
    oneof_schema_3_validator: Optional[RepositoryRuleDeletion] = None
    # data type: RepositoryRuleRequiredLinearHistory
    oneof_schema_4_validator: Optional[RepositoryRuleRequiredLinearHistory] = None
    # data type: RepositoryRuleMergeQueue
    oneof_schema_5_validator: Optional[RepositoryRuleMergeQueue] = None
    # data type: RepositoryRuleRequiredDeployments
    oneof_schema_6_validator: Optional[RepositoryRuleRequiredDeployments] = None
    # data type: RepositoryRuleRequiredSignatures
    oneof_schema_7_validator: Optional[RepositoryRuleRequiredSignatures] = None
    # data type: RepositoryRulePullRequest
    oneof_schema_8_validator: Optional[RepositoryRulePullRequest] = None
    # data type: RepositoryRuleRequiredStatusChecks
    oneof_schema_9_validator: Optional[RepositoryRuleRequiredStatusChecks] = None
    # data type: RepositoryRuleNonFastForward
    oneof_schema_10_validator: Optional[RepositoryRuleNonFastForward] = None
    # data type: RepositoryRuleCommitMessagePattern
    oneof_schema_11_validator: Optional[RepositoryRuleCommitMessagePattern] = None
    # data type: RepositoryRuleCommitAuthorEmailPattern
    oneof_schema_12_validator: Optional[RepositoryRuleCommitAuthorEmailPattern] = None
    # data type: RepositoryRuleCommitterEmailPattern
    oneof_schema_13_validator: Optional[RepositoryRuleCommitterEmailPattern] = None
    # data type: RepositoryRuleBranchNamePattern
    oneof_schema_14_validator: Optional[RepositoryRuleBranchNamePattern] = None
    # data type: RepositoryRuleTagNamePattern
    oneof_schema_15_validator: Optional[RepositoryRuleTagNamePattern] = None
    # data type: RepositoryRuleFilePathRestriction
    oneof_schema_16_validator: Optional[RepositoryRuleFilePathRestriction] = None
    # data type: RepositoryRuleMaxFilePathLength
    oneof_schema_17_validator: Optional[RepositoryRuleMaxFilePathLength] = None
    # data type: RepositoryRuleFileExtensionRestriction
    oneof_schema_18_validator: Optional[RepositoryRuleFileExtensionRestriction] = None
    # data type: RepositoryRuleMaxFileSize
    oneof_schema_19_validator: Optional[RepositoryRuleMaxFileSize] = None
    # data type: RepositoryRuleWorkflows
    oneof_schema_20_validator: Optional[RepositoryRuleWorkflows] = None
    # data type: RepositoryRuleCodeScanning
    oneof_schema_21_validator: Optional[RepositoryRuleCodeScanning] = None
    # data type: RepositoryRuleCopilotCodeReview
    oneof_schema_22_validator: Optional[RepositoryRuleCopilotCodeReview] = None
    actual_instance: Optional[Union[RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows]] = None
    one_of_schemas: Set[str] = { "RepositoryRuleBranchNamePattern", "RepositoryRuleCodeScanning", "RepositoryRuleCommitAuthorEmailPattern", "RepositoryRuleCommitMessagePattern", "RepositoryRuleCommitterEmailPattern", "RepositoryRuleCopilotCodeReview", "RepositoryRuleCreation", "RepositoryRuleDeletion", "RepositoryRuleFileExtensionRestriction", "RepositoryRuleFilePathRestriction", "RepositoryRuleMaxFilePathLength", "RepositoryRuleMaxFileSize", "RepositoryRuleMergeQueue", "RepositoryRuleNonFastForward", "RepositoryRulePullRequest", "RepositoryRuleRequiredDeployments", "RepositoryRuleRequiredLinearHistory", "RepositoryRuleRequiredSignatures", "RepositoryRuleRequiredStatusChecks", "RepositoryRuleTagNamePattern", "RepositoryRuleUpdate", "RepositoryRuleWorkflows" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = RepositoryRule.model_construct()
        error_messages = []
        match = 0
        # validate data type: RepositoryRuleCreation
        if not isinstance(v, RepositoryRuleCreation):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCreation`")
        else:
            match += 1
        # validate data type: RepositoryRuleUpdate
        if not isinstance(v, RepositoryRuleUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleUpdate`")
        else:
            match += 1
        # validate data type: RepositoryRuleDeletion
        if not isinstance(v, RepositoryRuleDeletion):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleDeletion`")
        else:
            match += 1
        # validate data type: RepositoryRuleRequiredLinearHistory
        if not isinstance(v, RepositoryRuleRequiredLinearHistory):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleRequiredLinearHistory`")
        else:
            match += 1
        # validate data type: RepositoryRuleMergeQueue
        if not isinstance(v, RepositoryRuleMergeQueue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleMergeQueue`")
        else:
            match += 1
        # validate data type: RepositoryRuleRequiredDeployments
        if not isinstance(v, RepositoryRuleRequiredDeployments):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleRequiredDeployments`")
        else:
            match += 1
        # validate data type: RepositoryRuleRequiredSignatures
        if not isinstance(v, RepositoryRuleRequiredSignatures):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleRequiredSignatures`")
        else:
            match += 1
        # validate data type: RepositoryRulePullRequest
        if not isinstance(v, RepositoryRulePullRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRulePullRequest`")
        else:
            match += 1
        # validate data type: RepositoryRuleRequiredStatusChecks
        if not isinstance(v, RepositoryRuleRequiredStatusChecks):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleRequiredStatusChecks`")
        else:
            match += 1
        # validate data type: RepositoryRuleNonFastForward
        if not isinstance(v, RepositoryRuleNonFastForward):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleNonFastForward`")
        else:
            match += 1
        # validate data type: RepositoryRuleCommitMessagePattern
        if not isinstance(v, RepositoryRuleCommitMessagePattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCommitMessagePattern`")
        else:
            match += 1
        # validate data type: RepositoryRuleCommitAuthorEmailPattern
        if not isinstance(v, RepositoryRuleCommitAuthorEmailPattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCommitAuthorEmailPattern`")
        else:
            match += 1
        # validate data type: RepositoryRuleCommitterEmailPattern
        if not isinstance(v, RepositoryRuleCommitterEmailPattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCommitterEmailPattern`")
        else:
            match += 1
        # validate data type: RepositoryRuleBranchNamePattern
        if not isinstance(v, RepositoryRuleBranchNamePattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleBranchNamePattern`")
        else:
            match += 1
        # validate data type: RepositoryRuleTagNamePattern
        if not isinstance(v, RepositoryRuleTagNamePattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleTagNamePattern`")
        else:
            match += 1
        # validate data type: RepositoryRuleFilePathRestriction
        if not isinstance(v, RepositoryRuleFilePathRestriction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleFilePathRestriction`")
        else:
            match += 1
        # validate data type: RepositoryRuleMaxFilePathLength
        if not isinstance(v, RepositoryRuleMaxFilePathLength):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleMaxFilePathLength`")
        else:
            match += 1
        # validate data type: RepositoryRuleFileExtensionRestriction
        if not isinstance(v, RepositoryRuleFileExtensionRestriction):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleFileExtensionRestriction`")
        else:
            match += 1
        # validate data type: RepositoryRuleMaxFileSize
        if not isinstance(v, RepositoryRuleMaxFileSize):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleMaxFileSize`")
        else:
            match += 1
        # validate data type: RepositoryRuleWorkflows
        if not isinstance(v, RepositoryRuleWorkflows):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleWorkflows`")
        else:
            match += 1
        # validate data type: RepositoryRuleCodeScanning
        if not isinstance(v, RepositoryRuleCodeScanning):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCodeScanning`")
        else:
            match += 1
        # validate data type: RepositoryRuleCopilotCodeReview
        if not isinstance(v, RepositoryRuleCopilotCodeReview):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RepositoryRuleCopilotCodeReview`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in RepositoryRule with oneOf schemas: RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in RepositoryRule with oneOf schemas: RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RepositoryRuleCreation
        try:
            instance.actual_instance = RepositoryRuleCreation.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleUpdate
        try:
            instance.actual_instance = RepositoryRuleUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleDeletion
        try:
            instance.actual_instance = RepositoryRuleDeletion.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleRequiredLinearHistory
        try:
            instance.actual_instance = RepositoryRuleRequiredLinearHistory.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleMergeQueue
        try:
            instance.actual_instance = RepositoryRuleMergeQueue.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleRequiredDeployments
        try:
            instance.actual_instance = RepositoryRuleRequiredDeployments.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleRequiredSignatures
        try:
            instance.actual_instance = RepositoryRuleRequiredSignatures.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRulePullRequest
        try:
            instance.actual_instance = RepositoryRulePullRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleRequiredStatusChecks
        try:
            instance.actual_instance = RepositoryRuleRequiredStatusChecks.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleNonFastForward
        try:
            instance.actual_instance = RepositoryRuleNonFastForward.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleCommitMessagePattern
        try:
            instance.actual_instance = RepositoryRuleCommitMessagePattern.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleCommitAuthorEmailPattern
        try:
            instance.actual_instance = RepositoryRuleCommitAuthorEmailPattern.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleCommitterEmailPattern
        try:
            instance.actual_instance = RepositoryRuleCommitterEmailPattern.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleBranchNamePattern
        try:
            instance.actual_instance = RepositoryRuleBranchNamePattern.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleTagNamePattern
        try:
            instance.actual_instance = RepositoryRuleTagNamePattern.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleFilePathRestriction
        try:
            instance.actual_instance = RepositoryRuleFilePathRestriction.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleMaxFilePathLength
        try:
            instance.actual_instance = RepositoryRuleMaxFilePathLength.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleFileExtensionRestriction
        try:
            instance.actual_instance = RepositoryRuleFileExtensionRestriction.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleMaxFileSize
        try:
            instance.actual_instance = RepositoryRuleMaxFileSize.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleWorkflows
        try:
            instance.actual_instance = RepositoryRuleWorkflows.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleCodeScanning
        try:
            instance.actual_instance = RepositoryRuleCodeScanning.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RepositoryRuleCopilotCodeReview
        try:
            instance.actual_instance = RepositoryRuleCopilotCodeReview.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into RepositoryRule with oneOf schemas: RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RepositoryRule with oneOf schemas: RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RepositoryRuleBranchNamePattern, RepositoryRuleCodeScanning, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleCopilotCodeReview, RepositoryRuleCreation, RepositoryRuleDeletion, RepositoryRuleFileExtensionRestriction, RepositoryRuleFilePathRestriction, RepositoryRuleMaxFilePathLength, RepositoryRuleMaxFileSize, RepositoryRuleMergeQueue, RepositoryRuleNonFastForward, RepositoryRulePullRequest, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredSignatures, RepositoryRuleRequiredStatusChecks, RepositoryRuleTagNamePattern, RepositoryRuleUpdate, RepositoryRuleWorkflows]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


