# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class RepositoryRuleParamsCodeScanningTool(BaseModel):
    """
    A tool that must provide code scanning results for this rule to pass.
    """ # noqa: E501
    alerts_threshold: StrictStr = Field(description="The severity level at which code scanning results that raise alerts block a reference update. For more information on alert severity levels, see \"[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels).\"")
    security_alerts_threshold: StrictStr = Field(description="The severity level at which code scanning results that raise security alerts block a reference update. For more information on security severity levels, see \"[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels).\"")
    tool: StrictStr = Field(description="The name of a code scanning tool")
    __properties: ClassVar[List[str]] = ["alerts_threshold", "security_alerts_threshold", "tool"]

    @field_validator('alerts_threshold')
    def alerts_threshold_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['none', 'errors', 'errors_and_warnings', 'all']):
            raise ValueError("must be one of enum values ('none', 'errors', 'errors_and_warnings', 'all')")
        return value

    @field_validator('security_alerts_threshold')
    def security_alerts_threshold_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['none', 'critical', 'high_or_higher', 'medium_or_higher', 'all']):
            raise ValueError("must be one of enum values ('none', 'critical', 'high_or_higher', 'medium_or_higher', 'all')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryRuleParamsCodeScanningTool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryRuleParamsCodeScanningTool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alerts_threshold": obj.get("alerts_threshold"),
            "security_alerts_threshold": obj.get("security_alerts_threshold"),
            "tool": obj.get("tool")
        })
        return _obj


