# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RepositoryRulePullRequestParameters(BaseModel):
    """
    RepositoryRulePullRequestParameters
    """ # noqa: E501
    allowed_merge_methods: Optional[List[StrictStr]] = Field(default=None, description="Array of allowed merge methods. Allowed values include `merge`, `squash`, and `rebase`. At least one option must be enabled.")
    automatic_copilot_code_review_enabled: Optional[StrictBool] = Field(default=None, description="Request Copilot code review for new pull requests automatically if the author has access to Copilot code review.")
    dismiss_stale_reviews_on_push: StrictBool = Field(description="New, reviewable commits pushed will dismiss previous pull request review approvals.")
    require_code_owner_review: StrictBool = Field(description="Require an approving review in pull requests that modify files that have a designated code owner.")
    require_last_push_approval: StrictBool = Field(description="Whether the most recent reviewable push must be approved by someone other than the person who pushed it.")
    required_approving_review_count: Annotated[int, Field(le=10, strict=True, ge=0)] = Field(description="The number of approving reviews that are required before a pull request can be merged.")
    required_review_thread_resolution: StrictBool = Field(description="All conversations on code must be resolved before a pull request can be merged.")
    __properties: ClassVar[List[str]] = ["allowed_merge_methods", "automatic_copilot_code_review_enabled", "dismiss_stale_reviews_on_push", "require_code_owner_review", "require_last_push_approval", "required_approving_review_count", "required_review_thread_resolution"]

    @field_validator('allowed_merge_methods')
    def allowed_merge_methods_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['merge', 'squash', 'rebase']):
                raise ValueError("each list item must be one of ('merge', 'squash', 'rebase')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryRulePullRequestParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryRulePullRequestParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowed_merge_methods": obj.get("allowed_merge_methods"),
            "automatic_copilot_code_review_enabled": obj.get("automatic_copilot_code_review_enabled"),
            "dismiss_stale_reviews_on_push": obj.get("dismiss_stale_reviews_on_push"),
            "require_code_owner_review": obj.get("require_code_owner_review"),
            "require_last_push_approval": obj.get("require_last_push_approval"),
            "required_approving_review_count": obj.get("required_approving_review_count"),
            "required_review_thread_resolution": obj.get("required_review_thread_resolution")
        })
        return _obj


