# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.repository_rule import RepositoryRule
from devopso.clients.github.models.repository_rule_enforcement import RepositoryRuleEnforcement
from devopso.clients.github.models.repository_ruleset_bypass_actor import RepositoryRulesetBypassActor
from devopso.clients.github.models.repository_ruleset_conditions import RepositoryRulesetConditions
from devopso.clients.github.models.repository_ruleset_links import RepositoryRulesetLinks
from typing import Optional, Set
from typing_extensions import Self

class RepositoryRuleset(BaseModel):
    """
    A set of rules to apply when specified conditions are met.
    """ # noqa: E501
    id: StrictInt = Field(description="The ID of the ruleset")
    name: StrictStr = Field(description="The name of the ruleset")
    target: Optional[StrictStr] = Field(default=None, description="The target of the ruleset")
    source_type: Optional[StrictStr] = Field(default=None, description="The type of the source of the ruleset")
    source: StrictStr = Field(description="The name of the source")
    enforcement: RepositoryRuleEnforcement
    bypass_actors: Optional[List[RepositoryRulesetBypassActor]] = Field(default=None, description="The actors that can bypass the rules in this ruleset")
    current_user_can_bypass: Optional[StrictStr] = Field(default=None, description="The bypass type of the user making the API request for this ruleset. This field is only returned when querying the repository-level endpoint.")
    node_id: Optional[StrictStr] = None
    links: Optional[RepositoryRulesetLinks] = Field(default=None, alias="_links")
    conditions: Optional[RepositoryRulesetConditions] = None
    rules: Optional[List[RepositoryRule]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "name", "target", "source_type", "source", "enforcement", "bypass_actors", "current_user_can_bypass", "node_id", "_links", "conditions", "rules", "created_at", "updated_at"]

    @field_validator('target')
    def target_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['branch', 'tag', 'push', 'repository']):
            raise ValueError("must be one of enum values ('branch', 'tag', 'push', 'repository')")
        return value

    @field_validator('source_type')
    def source_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Repository', 'Organization', 'Enterprise']):
            raise ValueError("must be one of enum values ('Repository', 'Organization', 'Enterprise')")
        return value

    @field_validator('current_user_can_bypass')
    def current_user_can_bypass_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['always', 'pull_requests_only', 'never', 'exempt']):
            raise ValueError("must be one of enum values ('always', 'pull_requests_only', 'never', 'exempt')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryRuleset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bypass_actors (list)
        _items = []
        if self.bypass_actors:
            for _item_bypass_actors in self.bypass_actors:
                if _item_bypass_actors:
                    _items.append(_item_bypass_actors.to_dict())
            _dict['bypass_actors'] = _items
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['rules'] = _items
        # set to None if conditions (nullable) is None
        # and model_fields_set contains the field
        if self.conditions is None and "conditions" in self.model_fields_set:
            _dict['conditions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryRuleset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "target": obj.get("target"),
            "source_type": obj.get("source_type"),
            "source": obj.get("source"),
            "enforcement": obj.get("enforcement"),
            "bypass_actors": [RepositoryRulesetBypassActor.from_dict(_item) for _item in obj["bypass_actors"]] if obj.get("bypass_actors") is not None else None,
            "current_user_can_bypass": obj.get("current_user_can_bypass"),
            "node_id": obj.get("node_id"),
            "_links": RepositoryRulesetLinks.from_dict(obj["_links"]) if obj.get("_links") is not None else None,
            "conditions": RepositoryRulesetConditions.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "rules": [RepositoryRule.from_dict(_item) for _item in obj["rules"]] if obj.get("rules") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


